% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{getTexture}
\alias{getTexture}
\title{Save a point symbol as a temporary file.}
\usage{
getTexture(pch = 16, cex = 10, ...)
}
\arguments{
\item{pch}{Point number/symbol.}

\item{cex}{Point size}

\item{...}{Further arguments passed to \code{plot}.}
}
\value{
The file name.
}
\description{
Save a point symbol as a temporary file.
}
\examples{
\donttest{
# Pch shapes
generateRPointShapes<-function(){
   oldPar<-par()
   par(font=2, mar=c(0.5,0,0,0))
   y=rev(c(rep(1,6),rep(2,5), rep(3,5), rep(4,5), rep(5,5)))
   x=c(rep(1:5,5),6)
   plot(x, y, pch = 0:25, cex=1.5, ylim=c(1,5.5), xlim=c(1,6.5),
        axes=FALSE, xlab="", ylab="", bg="blue")
   text(x, y, labels=0:25, pos=3)
   par(mar=oldPar$mar,font=oldPar$font )
}
generateRPointShapes()

getTexture()
}
}
