% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gfs.R
\name{read_gfs}
\alias{read_gfs}
\title{Reads GFS-3000 text files and creates a tibble with gas-exchange data}
\usage{
read_gfs(
  filename,
  tz = Sys.timezone(),
  unified_names = TRUE,
  skip_to_data = 2,
  delim = ";"
)
}
\arguments{
\item{filename}{an xlsx file containing 6800 gas-exchange data.}

\item{tz}{a character string specifying the timezone for the loaded file. If
omitted, the current time zone is used. Invalid values are typically
treated as UTC, on some platforms with a warning.}

\item{unified_names}{= TRUE, use unified column names. This is necessary for
further processing of the data using this package.}

\item{skip_to_data}{use skip=4 if the file has a double header.}

\item{delim}{= ";" Allows specified the delimiter used in the files. Re-saved
data may use a comma as delimiter.}
}
\value{
a tibble with gas-exchange data in columns and equations as
attribute.
}
\description{
The text files stored by the GFS-3000 contain measured and calculated values
that are read by this function and formatted in a large tibble for use with
R. Note that no recalculation of derived variables is performed, although it
is possible to do so using \code{\link[=recalculate]{recalculate()}} after importing the data.
}
\details{
Multiple files can be loaded by calling the function with \code{\link[=lapply]{lapply()}} or
\code{\link[purrr:map]{purrr::map()}} to merge multiple files. In this case, it is important
to ensure that the column names will match.
}
\examples{
example <- system.file("extdata", "aci1.csv", package = "gasanalyzer")

# Read using GFS-3000 names and formatting:
gfs3000_old <- read_gfs(example, unified_names = FALSE)
# Read using unified column names:
gfs3000 <- read_gfs(example)

# Inspect the intercellular CO2:
gfs3000_old$ci
gfs3000$GasEx.Ci

# Recalculate data using default gas exchange equations:
gfs3000 <- recalculate(gfs3000, create_equations(c("default", "gfs3000")))
gfs3000$GasEx.Ci
}
\seealso{
\code{\link[=recalculate]{recalculate()}}
}
