// Generated by rstantools.  Do not edit by hand.

/*
    breathteststan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    breathteststan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with breathteststan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_powexp_gastro_2c_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 73> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 40, column 2 to column 45)",
  " (in 'string', line 41, column 2 to column 34)",
  " (in 'string', line 42, column 2 to column 25)",
  " (in 'string', line 43, column 2 to column 26)",
  " (in 'string', line 44, column 2 to column 22)",
  " (in 'string', line 45, column 2 to column 32)",
  " (in 'string', line 46, column 2 to column 24)",
  " (in 'string', line 49, column 2 to column 25)",
  " (in 'string', line 81, column 2 to column 22)",
  " (in 'string', line 82, column 2 to column 25)",
  " (in 'string', line 83, column 2 to column 24)",
  " (in 'string', line 50, column 2 to column 53)",
  " (in 'string', line 85, column 2 to column 23)",
  " (in 'string', line 87, column 4 to column 34)",
  " (in 'string', line 88, column 4 to column 32)",
  " (in 'string', line 86, column 23 to line 89, column 3)",
  " (in 'string', line 86, column 2 to line 89, column 3)",
  " (in 'string', line 53, column 2 to column 11)",
  " (in 'string', line 54, column 2 to column 11)",
  " (in 'string', line 55, column 2 to column 13)",
  " (in 'string', line 56, column 2 to column 14)",
  " (in 'string', line 57, column 9 to column 10)",
  " (in 'string', line 57, column 2 to column 15)",
  " (in 'string', line 61, column 2 to column 33)",
  " (in 'string', line 62, column 2 to column 29)",
  " (in 'string', line 63, column 2 to column 25)",
  " (in 'string', line 64, column 2 to column 29)",
  " (in 'string', line 65, column 2 to column 29)",
  " (in 'string', line 66, column 2 to column 33)",
  " (in 'string', line 67, column 2 to column 34)",
  " (in 'string', line 68, column 2 to column 26)",
  " (in 'string', line 70, column 3 to column 19)",
  " (in 'string', line 71, column 3 to column 19)",
  " (in 'string', line 72, column 3 to column 34)",
  " (in 'string', line 73, column 3 to column 32)",
  " (in 'string', line 74, column 3 to column 46)",
  " (in 'string', line 69, column 14 to line 75, column 3)",
  " (in 'string', line 69, column 0 to line 75, column 3)",
  " (in 'string', line 78, column 2 to column 46)",
  " (in 'string', line 12, column 2 to column 11)",
  " (in 'string', line 13, column 2 to column 17)",
  " (in 'string', line 14, column 2 to column 17)",
  " (in 'string', line 15, column 2 to column 24)",
  " (in 'string', line 16, column 8 to column 9)",
  " (in 'string', line 16, column 2 to column 22)",
  " (in 'string', line 17, column 9 to column 10)",
  " (in 'string', line 17, column 2 to column 19)",
  " (in 'string', line 18, column 9 to column 10)",
  " (in 'string', line 18, column 2 to column 19)",
  " (in 'string', line 21, column 4 to column 20)",
  " (in 'string', line 22, column 11 to column 12)",
  " (in 'string', line 22, column 4 to column 23)",
  " (in 'string', line 23, column 4 to column 18)",
  " (in 'string', line 24, column 4 to column 15)",
  " (in 'string', line 25, column 4 to column 17)",
  " (in 'string', line 26, column 4 to column 17)",
  " (in 'string', line 27, column 4 to column 15)",
  " (in 'string', line 28, column 4 to column 17)",
  " (in 'string', line 32, column 8 to column 30)",
  " (in 'string', line 33, column 8 to column 21)",
  " (in 'string', line 31, column 25 to line 34, column 7)",
  " (in 'string', line 31, column 6 to line 34, column 7)",
  " (in 'string', line 30, column 18 to line 35, column 5)",
  " (in 'string', line 30, column 4 to line 35, column 5)",
  " (in 'string', line 36, column 4 to column 23)",
  " (in 'string', line 37, column 4 to column 31)",
  " (in 'string', line 40, column 30 to column 38)",
  " (in 'string', line 46, column 12 to column 20)",
  " (in 'string', line 49, column 9 to column 17)",
  " (in 'string', line 81, column 9 to column 17)",
  " (in 'string', line 82, column 9 to column 17)",
  " (in 'string', line 83, column 9 to column 17)"};
#include <stan_meta_header.hpp>
class model_powexp_gastro_2c final : public model_base_crtp<model_powexp_gastro_2c> {
private:
  double lkj;
  int student_df;
  int n;
  int n_record;
  std::vector<int> record;
  Eigen::Matrix<double,-1,1> minute_data__;
  Eigen::Matrix<double,-1,1> volume_data__;
  Eigen::Matrix<double,-1,1> zeros_data__;
  Eigen::Matrix<double,-1,1> volume_1_data__;
  double norm_vol;
  int n_norm;
  Eigen::Map<Eigen::Matrix<double,-1,1>> minute{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> volume{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> zeros{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> volume_1{nullptr, 0};
public:
  ~model_powexp_gastro_2c() {}
  model_powexp_gastro_2c(stan::io::var_context& context__, unsigned int
                         random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_powexp_gastro_2c_namespace::model_powexp_gastro_2c";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 40;
      context__.validate_dims("data initialization", "lkj", "double",
        std::vector<size_t>{});
      lkj = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 40;
      lkj = context__.vals_r("lkj")[(1 - 1)];
      current_statement__ = 41;
      context__.validate_dims("data initialization", "student_df", "int",
        std::vector<size_t>{});
      student_df = std::numeric_limits<int>::min();
      current_statement__ = 41;
      student_df = context__.vals_i("student_df")[(1 - 1)];
      current_statement__ = 42;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 42;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 42;
      stan::math::check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 43;
      context__.validate_dims("data initialization", "n_record", "int",
        std::vector<size_t>{});
      n_record = std::numeric_limits<int>::min();
      current_statement__ = 43;
      n_record = context__.vals_i("n_record")[(1 - 1)];
      current_statement__ = 43;
      stan::math::check_greater_or_equal(function__, "n_record", n_record, 0);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("record", "n", n);
      current_statement__ = 45;
      context__.validate_dims("data initialization", "record", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      record = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 45;
      record = context__.vals_i("record");
      current_statement__ = 46;
      stan::math::validate_non_negative_index("minute", "n", n);
      current_statement__ = 47;
      context__.validate_dims("data initialization", "minute", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      minute_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                        std::numeric_limits<double>::quiet_NaN());
      new (&minute)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(minute_data__.data(), n);
      {
        std::vector<local_scalar_t__> minute_flat__;
        current_statement__ = 47;
        minute_flat__ = context__.vals_r("minute");
        current_statement__ = 47;
        pos__ = 1;
        current_statement__ = 47;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 47;
          stan::model::assign(minute, minute_flat__[(pos__ - 1)],
            "assigning variable minute", stan::model::index_uni(sym1__));
          current_statement__ = 47;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 48;
      stan::math::validate_non_negative_index("volume", "n", n);
      current_statement__ = 49;
      context__.validate_dims("data initialization", "volume", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      volume_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                        std::numeric_limits<double>::quiet_NaN());
      new (&volume)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(volume_data__.data(), n);
      {
        std::vector<local_scalar_t__> volume_flat__;
        current_statement__ = 49;
        volume_flat__ = context__.vals_r("volume");
        current_statement__ = 49;
        pos__ = 1;
        current_statement__ = 49;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 49;
          stan::model::assign(volume, volume_flat__[(pos__ - 1)],
            "assigning variable volume", stan::model::index_uni(sym1__));
          current_statement__ = 49;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 50;
      zeros_data__ = Eigen::Matrix<double,-1,1>::Constant(2,
                       std::numeric_limits<double>::quiet_NaN());
      new (&zeros)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(zeros_data__.data(), 2);
      current_statement__ = 51;
      stan::math::validate_non_negative_index("volume_1", "n", n);
      current_statement__ = 52;
      volume_1_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                          std::numeric_limits<double>::quiet_NaN());
      new (&volume_1)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(volume_1_data__.data(), n);
      current_statement__ = 53;
      norm_vol = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 54;
      n_norm = std::numeric_limits<int>::min();
      current_statement__ = 55;
      stan::model::assign(zeros, 0, "assigning variable zeros",
        stan::model::index_uni(1));
      current_statement__ = 56;
      stan::model::assign(zeros, 0, "assigning variable zeros",
        stan::model::index_uni(2));
      current_statement__ = 57;
      n_norm = 0;
      current_statement__ = 58;
      norm_vol = 0;
      current_statement__ = 64;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 62;
        if (stan::math::logical_lt(
              stan::model::rvalue(minute, "minute", stan::model::index_uni(i)),
              5)) {
          current_statement__ = 59;
          norm_vol = (norm_vol +
            stan::model::rvalue(volume, "volume", stan::model::index_uni(i)));
          current_statement__ = 60;
          n_norm = (n_norm + 1);
        }
      }
      current_statement__ = 65;
      norm_vol = (norm_vol / n_norm);
      current_statement__ = 66;
      stan::model::assign(volume_1, stan::math::divide(volume, norm_vol),
        "assigning variable volume_1");
      current_statement__ = 67;
      stan::math::validate_non_negative_index("v0_1", "n_record", n_record);
      current_statement__ = 68;
      stan::math::validate_non_negative_index("z", "n_record", n_record);
      current_statement__ = 69;
      stan::math::validate_non_negative_index("cf", "n_record", n_record);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("v0", "n_record", n_record);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("tempt", "n_record", n_record);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("beta", "n_record", n_record);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = n_record + 2 + 1 + 1 + 1 + ((2 * (2 - 1)) / 2) + (2 *
      n_record);
  }
  inline std::string model_name() const final {
    return "model_powexp_gastro_2c";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_powexp_gastro_2c_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> v0_1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 1;
      v0_1 = in__.template read_constrain_lub<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, 2, lp__,
               n_record);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_record =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(2, DUMMY_VAR__);
      current_statement__ = 2;
      sigma_record = in__.template read_constrain_lb<
                       Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                       lp__, 2);
      local_scalar_t__ mu_beta = DUMMY_VAR__;
      current_statement__ = 3;
      mu_beta = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      local_scalar_t__ mu_tempt = DUMMY_VAR__;
      current_statement__ = 4;
      mu_tempt = in__.template read_constrain_lb<local_scalar_t__,
                   jacobian__>(0, lp__);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 5;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_rho =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(2, 2, DUMMY_VAR__);
      current_statement__ = 6;
      L_rho = in__.template read_constrain_cholesky_factor_corr<
                Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__, 2);
      Eigen::Matrix<local_scalar_t__,-1,-1> z =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(2, n_record,
          DUMMY_VAR__);
      current_statement__ = 7;
      z = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(2,
            n_record);
      Eigen::Matrix<local_scalar_t__,-1,-1> cf =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_record, 2,
          DUMMY_VAR__);
      current_statement__ = 12;
      stan::model::assign(cf,
        stan::math::transpose(
          stan::math::multiply(
            stan::math::diag_pre_multiply(sigma_record, L_rho), z)),
        "assigning variable cf");
      {
        int rec = std::numeric_limits<int>::min();
        local_scalar_t__ v0r = DUMMY_VAR__;
        local_scalar_t__ betar = DUMMY_VAR__;
        local_scalar_t__ temptr = DUMMY_VAR__;
        current_statement__ = 22;
        stan::math::validate_non_negative_index("mu", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,1> mu =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
        current_statement__ = 24;
        lp_accum__.add(stan::math::lkj_corr_cholesky_lpdf<propto__>(L_rho,
                         lkj));
        current_statement__ = 25;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::math::to_vector(z), 0, 1));
        current_statement__ = 26;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(v0_1, 1, 0.3));
        current_statement__ = 27;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(mu_beta, 1.2, 0.5));
        current_statement__ = 28;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(mu_tempt, 100, 50));
        current_statement__ = 29;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(
                         stan::model::rvalue(sigma_record, "sigma_record",
                           stan::model::index_uni(1)), 0, 20));
        current_statement__ = 30;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(
                         stan::model::rvalue(sigma_record, "sigma_record",
                           stan::model::index_uni(2)), 0, 0.4));
        current_statement__ = 31;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma, 0., 0.5));
        current_statement__ = 38;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 32;
          rec = stan::model::rvalue(record, "record",
                  stan::model::index_uni(i));
          current_statement__ = 33;
          v0r = stan::model::rvalue(v0_1, "v0_1", stan::model::index_uni(rec));
          current_statement__ = 34;
          temptr = (mu_tempt +
            stan::model::rvalue(cf, "cf", stan::model::index_uni(rec),
              stan::model::index_uni(1)));
          current_statement__ = 35;
          betar = (mu_beta +
            stan::model::rvalue(cf, "cf", stan::model::index_uni(rec),
              stan::model::index_uni(2)));
          current_statement__ = 36;
          stan::model::assign(mu, (v0r *
            stan::math::exp(
              -stan::math::pow(
                 (stan::model::rvalue(minute, "minute",
                    stan::model::index_uni(i)) / temptr), betar))),
            "assigning variable mu", stan::model::index_uni(i));
        }
        current_statement__ = 39;
        lp_accum__.add(stan::math::student_t_lpdf<propto__>(volume_1,
                         student_df, mu, sigma));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_powexp_gastro_2c_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> v0_1 =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      v0_1 = in__.template read_constrain_lub<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, 2, lp__,
               n_record);
      Eigen::Matrix<double,-1,1> sigma_record =
        Eigen::Matrix<double,-1,1>::Constant(2,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      sigma_record = in__.template read_constrain_lb<
                       Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                       lp__, 2);
      double mu_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      mu_beta = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      double mu_tempt = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      mu_tempt = in__.template read_constrain_lb<local_scalar_t__,
                   jacobian__>(0, lp__);
      double sigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 5;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,-1> L_rho =
        Eigen::Matrix<double,-1,-1>::Constant(2, 2,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      L_rho = in__.template read_constrain_cholesky_factor_corr<
                Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__, 2);
      Eigen::Matrix<double,-1,-1> z =
        Eigen::Matrix<double,-1,-1>::Constant(2, n_record,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 7;
      z = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(2,
            n_record);
      Eigen::Matrix<double,-1,-1> cf =
        Eigen::Matrix<double,-1,-1>::Constant(n_record, 2,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(v0_1);
      out__.write(sigma_record);
      out__.write(mu_beta);
      out__.write(mu_tempt);
      out__.write(sigma);
      out__.write(L_rho);
      out__.write(z);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 12;
      stan::model::assign(cf,
        stan::math::transpose(
          stan::math::multiply(
            stan::math::diag_pre_multiply(sigma_record, L_rho), z)),
        "assigning variable cf");
      if (emit_transformed_parameters__) {
        out__.write(cf);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> v0 =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> tempt =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 13;
      stan::model::assign(v0, stan::math::multiply(v0_1, norm_vol),
        "assigning variable v0");
      current_statement__ = 17;
      for (int i = 1; i <= n_record; ++i) {
        current_statement__ = 14;
        stan::model::assign(tempt, (mu_tempt +
          stan::model::rvalue(cf, "cf", stan::model::index_uni(i),
            stan::model::index_uni(1))), "assigning variable tempt",
          stan::model::index_uni(i));
        current_statement__ = 15;
        stan::model::assign(beta, (mu_beta +
          stan::model::rvalue(cf, "cf", stan::model::index_uni(i),
            stan::model::index_uni(2))), "assigning variable beta",
          stan::model::index_uni(i));
      }
      out__.write(v0);
      out__.write(tempt);
      out__.write(beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> v0_1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(v0_1,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_record),
        "assigning variable v0_1");
      out__.write_free_lub(0, 2, v0_1);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_record =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(2, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(sigma_record,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(2),
        "assigning variable sigma_record");
      out__.write_free_lb(0, sigma_record);
      local_scalar_t__ mu_beta = DUMMY_VAR__;
      current_statement__ = 3;
      mu_beta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, mu_beta);
      local_scalar_t__ mu_tempt = DUMMY_VAR__;
      current_statement__ = 4;
      mu_tempt = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, mu_tempt);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 5;
      sigma = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_rho =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(2, 2, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(L_rho,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(2, 2),
        "assigning variable L_rho");
      out__.write_free_cholesky_factor_corr(L_rho);
      Eigen::Matrix<local_scalar_t__,-1,-1> z =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(2, n_record,
          DUMMY_VAR__);
      current_statement__ = 7;
      stan::model::assign(z,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(2, n_record),
        "assigning variable z");
      out__.write(z);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "v0_1", "double",
        std::vector<size_t>{static_cast<size_t>(n_record)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_record",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "mu_beta",
        "double", std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "mu_tempt",
        "double", std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "sigma", "double",
        std::vector<size_t>{});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "L_rho", "double",
        std::vector<size_t>{static_cast<size_t>(2), static_cast<size_t>(2)});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "z", "double",
        std::vector<size_t>{static_cast<size_t>(2),
          static_cast<size_t>(n_record)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> v0_1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> v0_1_flat__;
        current_statement__ = 1;
        v0_1_flat__ = context__.vals_r("v0_1");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(v0_1, v0_1_flat__[(pos__ - 1)],
            "assigning variable v0_1", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lub(0, 2, v0_1);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_record =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(2, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> sigma_record_flat__;
        current_statement__ = 2;
        sigma_record_flat__ = context__.vals_r("sigma_record");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(sigma_record, sigma_record_flat__[(pos__ - 1)],
            "assigning variable sigma_record", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, sigma_record);
      local_scalar_t__ mu_beta = DUMMY_VAR__;
      current_statement__ = 3;
      mu_beta = context__.vals_r("mu_beta")[(1 - 1)];
      out__.write_free_lb(0, mu_beta);
      local_scalar_t__ mu_tempt = DUMMY_VAR__;
      current_statement__ = 4;
      mu_tempt = context__.vals_r("mu_tempt")[(1 - 1)];
      out__.write_free_lb(0, mu_tempt);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 5;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      out__.write_free_lb(0, sigma);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_rho =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(2, 2, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> L_rho_flat__;
        current_statement__ = 6;
        L_rho_flat__ = context__.vals_r("L_rho");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
            current_statement__ = 6;
            stan::model::assign(L_rho, L_rho_flat__[(pos__ - 1)],
              "assigning variable L_rho", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 6;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write_free_cholesky_factor_corr(L_rho);
      Eigen::Matrix<local_scalar_t__,-1,-1> z =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(2, n_record,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> z_flat__;
        current_statement__ = 7;
        z_flat__ = context__.vals_r("z");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 7;
          for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
            current_statement__ = 7;
            stan::model::assign(z, z_flat__[(pos__ - 1)],
              "assigning variable z", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 7;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(z);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"v0_1", "sigma_record", "mu_beta",
                "mu_tempt", "sigma", "L_rho", "z"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"cf"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"v0", "tempt", "beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    n_record)},
                std::vector<size_t>{static_cast<size_t>(2)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(2),
                  static_cast<size_t>(2)},
                std::vector<size_t>{static_cast<size_t>(2),
                  static_cast<size_t>(n_record)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_record),
               static_cast<size_t>(2)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_record)},
             std::vector<size_t>{static_cast<size_t>(n_record)},
             std::vector<size_t>{static_cast<size_t>(n_record)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "v0_1" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_record" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_beta");
    param_names__.emplace_back(std::string() + "mu_tempt");
    param_names__.emplace_back(std::string() + "sigma");
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
        param_names__.emplace_back(std::string() + "L_rho" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
        param_names__.emplace_back(std::string() + "z" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_record; ++sym2__) {
          param_names__.emplace_back(std::string() + "cf" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "v0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "tempt" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "v0_1" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_record" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_beta");
    param_names__.emplace_back(std::string() + "mu_tempt");
    param_names__.emplace_back(std::string() + "sigma");
    for (int sym1__ = 1; sym1__ <= ((2 * (2 - 1)) / 2); ++sym1__) {
      param_names__.emplace_back(std::string() + "L_rho" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
        param_names__.emplace_back(std::string() + "z" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_record; ++sym2__) {
          param_names__.emplace_back(std::string() + "cf" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "v0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "tempt" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"v0_1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"sigma_record\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_tempt\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"L_rho\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(2) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(2) + ",\"cols\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"cf\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_record) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"transformed_parameters\"},{\"name\":\"v0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"generated_quantities\"},{\"name\":\"tempt\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"v0_1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"sigma_record\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_tempt\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"L_rho\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(((2 * (2 - 1)) /2)) + "},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(2) + ",\"cols\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"cf\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_record) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"transformed_parameters\"},{\"name\":\"v0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"generated_quantities\"},{\"name\":\"tempt\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((n_record + 2) + 1) + 1) + 1) + (2 * 2))
      + (2 * n_record));
    const size_t num_transformed = emit_transformed_parameters * ((n_record *
      2));
    const size_t num_gen_quantities = emit_generated_quantities * (((n_record
      + n_record) + n_record));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((n_record + 2) + 1) + 1) + 1) + (2 * 2))
      + (2 * n_record));
    const size_t num_transformed = emit_transformed_parameters * ((n_record *
      2));
    const size_t num_gen_quantities = emit_generated_quantities * (((n_record
      + n_record) + n_record));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_powexp_gastro_2c_namespace::model_powexp_gastro_2c;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_powexp_gastro_2c_namespace::profiles__;
}
#endif
#endif
