% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcite_papers.R
\name{gcite_papers}
\alias{gcite_papers}
\alias{gcite_papers.xml_nodeset}
\alias{gcite_papers.xml_document}
\alias{gcite_papers.character}
\alias{gcite_papers.default}
\title{Parse Google Citation Index}
\usage{
gcite_papers(doc, ...)

\method{gcite_papers}{xml_nodeset}(doc, ...)

\method{gcite_papers}{xml_document}(doc, ...)

\method{gcite_papers}{character}(doc, ...)

\method{gcite_papers}{default}(doc, ...)
}
\arguments{
\item{doc}{A xml_document or the url for the main page}

\item{...}{Additional arguments passed to \code{\link[httr]{GET}} if \code{doc}
is a URL}
}
\value{
A matrix of indices
}
\description{
Parses a google citation indices (h-index, etc.) from main page
}
\examples{
library(httr)
library(rvest) 
url = "https://scholar.google.com/citations?user=T9eqZgMAAAAJ"
url = gcite_url(url = url, pagesize = 10, cstart = 0) 
if (!is_travis() & !is_cran()) {
ind = gcite_papers(url)
doc = content(httr::GET(url))
ind = gcite_papers(doc)
ind_nodes = rvest::html_nodes(doc, "#gsc_a_b")
ind = gcite_papers(ind_nodes)
}
}
