% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setter_funcs.R
\name{set_countries}
\alias{set_countries}
\title{Set countries to retrieve data for}
\usage{
set_countries(session, countries)
}
\arguments{
\item{session}{A valid GDL session object to interface with.}

\item{countries}{A vector of ISO3 country codes.}
}
\value{
An amended GDL session object.
}
\description{
The countries to retrieve GDL indicator data for.
}
\examples{
\dontrun{
# Create a session using your API token (provided by environment here)
session <- gdl_session(Sys.getenv('GDL_API_TOKEN'))
# Customize parameters
session <- set_dataset(session, 'shdi')
session <- set_countries(session, c('BEL', 'LUX', 'NLD'))
}
}
