% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{writegdx.parameter}
\alias{writegdx.parameter}
\title{writegdx.parameter}
\usage{
writegdx.parameter(gdx, dt, name, valcol, uelcols)
}
\arguments{
\item{gdx}{the gdx filename.}

\item{dt}{a data.table.}

\item{name}{name of the parameter.}

\item{valcol}{name of data column.}

\item{uelcols}{vector of column names with index dimensions.}
}
\description{
Save a data.table to a parameter in a GAMS gdx file.
}
\examples{
\dontrun{
dt <- as.data.table(mtcars, keep.rownames = TRUE)
tmpgdx <- file.path(tempdir(), "test.gdx")
test_var <- "mtcars"
writegdx.parameter(tmpgdx, dt, test_var, valcol="wt", uelcols="rn")
new_dt <- readgdx(tmpgdx, test_var)
}
}
