% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_db.R
\name{read_db}
\alias{read_db}
\title{Reading, Aggregating, and Processing the SQLite Database}
\usage{
read_db(
  path,
  variables = "all",
  freq = c("month", "day", "week", "bimonth", "quarter", "season", "halfyear", "year"),
  prep_fun = NULL,
  aggr_funs = function(x) mean(x, na.rm = TRUE),
  postp_funs = NULL
)
}
\arguments{
\item{path}{[mandatory] (character) Path to the root directory of the
generated database.}

\item{variables}{[optional] (character or integer) Names or IDs of the
variables to be read. Use the \code{fetch_vars} function to identify
available variables and IDs (default: \code{"all"}).}

\item{freq}{[optional] (character or \code{NULL}) The frequency for data
aggregation. Options include \code{"day"}, \code{"week"}, \code{"month"},
\code{"bimonth"}, \code{"quarter"}, \code{"season"}, \code{"halfyear"},
\code{"year"} (default: \code{"month"}). If \code{NULL}, no aggregation is
performed and native dates are returned.}

\item{prep_fun}{[optional] (function or \code{NULL}) A function for
pre-processing time series data prior to aggregation. If \code{NULL}, a
default linear interpolation (via \code{\link{linear_interp}}) will be
used for daily-frequency data. If non-daily, the default behavior simply
returns the vector without interpolation.}

\item{aggr_funs}{[optional] (function or list) A function or a list of
functions for aggregating data to the specified frequency (\code{freq}).
Users can directly refer to variable names or IDs. The default function is
the mean: \code{function(x) mean(x, na.rm = TRUE)}.}

\item{postp_funs}{[optional] (function or list) A function or list of
functions applied to the time series data of a single bin after
aggregation. Users can directly refer to variable names or IDs. The
default is \code{NULL}, indicating no post-processing.}
}
\value{
A list where the first element (\code{grid}) is a simple feature
  (sf) object, and subsequent elements are data frame objects corresponding
  to the variables.
}
\description{
Reads, aggregates, and processes the SQLite database
  (\code{data/geelite.db}).
}
\examples{
# Example: Reading variables by IDs
\dontrun{
  db_list <- read_db(path = "path/to/db",
    variables = c(1, 3))
}

}
