% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_docs.R
\name{gemini_docs.vertex}
\alias{gemini_docs.vertex}
\title{Summarize or analyze documents using Vertex AI Gemini}
\usage{
gemini_docs.vertex(
  file_uri,
  prompt,
  mime_type = "application/pdf",
  tokens = NULL,
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234
)
}
\arguments{
\item{file_uri}{The URI(s) or URL(s) of the file(s) to include in the prompt. Accepts Cloud Storage URI (gs://...), HTTP(S) URL, or YouTube video URL.}

\item{prompt}{The text instructions to include in the prompt.}

\item{mime_type}{The media type of the file (e.g., "application/pdf", "text/plain").}

\item{tokens}{A list containing the API URL and key from token.vertex() function.}

\item{temperature}{The temperature to use. Default is 1.}

\item{maxOutputTokens}{The maximum number of tokens to generate. Default is 8192.}

\item{topK}{The top-k value to use. Default is 40.}

\item{topP}{The top-p value to use. Default is 0.95.}

\item{seed}{The seed to use. Default is 1234.}
}
\value{
The summary or response text from Gemini Vertex.
}
\description{
Summarize, compare, or analyze the content of one or more documents (PDF, TXT, HTML, etc.) using Vertex AI Gemini.
}
\examples{
\dontrun{
tokens <- token.vertex()
gemini_docs.vertex(
  file_uri = "gs://cloud-samples-data/generative-ai/pdf/2403.05530.pdf",
  prompt = "Summarize this document.",
  mime_type = "application/pdf",
  tokens = tokens
)
}
}
\seealso{
https://cloud.google.com/vertex-ai/docs/generative-ai/multimodal/send-request-document
}
