% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{hammingDist}
\alias{hammingDist}
\title{Hamming Distance}
\usage{
hammingDist(x, y)
}
\arguments{
\item{x}{Binary vector or matrix}

\item{y}{Binary vector or matrix of same dimensions as x.}
}
\value{
Numeric, elementwise Hamming distance between x and y.
}
\description{
Simple function to return the Hamming distance between two objects. Acts elementwise.
}
\note{
For speed, no error handling if x and y do not have the same dimensions. Also,
does not test to make sure x,y are binary, take care!
}
\examples{
x <- matrix(c(1,0,
              0,0), nrow = 2, byrow = TRUE)
y <- diag(1,2)
hammingDist(x, y)
}
