% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAccessions.R
\name{getAccessions}
\alias{getAccessions}
\title{Get the acessions ids and the organism for each protein identifier}
\usage{
getAccessions(protein_ids)
}
\arguments{
\item{protein_ids}{A string vector containing protein identifiers.}
}
\value{
A \code{data.frame} of protein ids including columns:
\itemize{
\item accession
\item organism  
}
}
\description{
The \code{getAccessions} function parses the protein page for each identifier 
and extracts the accession id (usually referred as XP accession in the RefSeq
database) and the organism given by the scientific name. 
 
The \code{accessions_by_spp} and \code{accessions_from_spp} functions are 
convenient filters for further cleaning of \code{getAccessions} by giving 
the total number of XP accessions per species or extracting the XP 
accessions for a given species, respectively.
}
\examples{
prot_ids <- c("593705262", "1379669790", "357520645",  "1150156484")
getAccessions(prot_ids)
 
}
\seealso{
\code{\link{accessions_by_spp}} to summarize the total number of 
  accession proteins per species.

\code{\link{accessions_from_spp}} to filter the accession ids for 
   a given species
}
\author{
Jose V. Die
}
