% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.gensvm.R
\name{print.gensvm}
\alias{print.gensvm}
\title{Print the fitted GenSVM model}
\usage{
\method{print}{gensvm}(x, ...)
}
\arguments{
\item{x}{A \code{gensvm} object to print}

\item{\dots}{further arguments are ignored}
}
\value{
returns the object passed as input. This can be useful for chaining 
operations on a fit object.
}
\description{
Prints a short description of the fitted GenSVM model
}
\examples{
x <- iris[, -5]
y <- iris[, 5]

# fit and print the model
fit <- gensvm(x, y)
print(fit)

# (advanced) use the fact that print returns the fitted model
fit <- gensvm(x, y)
predict(print(fit), x)

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{https://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm}}, \code{\link{predict.gensvm}}, 
\code{\link{plot.gensvm}}, \code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
