% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dist_focus.R
\name{get_dist_focus}
\alias{get_dist_focus}
\title{Get distance maps}
\usage{
get_dist_focus(
  window,
  lon,
  lat,
  resolution = NULL,
  ndim = NULL,
  mile = FALSE,
  preprocess = FALSE,
  input_crs = 4326,
  unit_scale = 1000
)
}
\arguments{
\item{window}{owin object}

\item{lon}{vector of longitudes}

\item{lat}{vector of latitudes}

\item{resolution}{resolution of raster (distance map) (in km; by default, 1). Ignored if npixel is set.}

\item{ndim}{number of pixels for both dimensions (e.g., 256 for 256x256). If set, resolution is ignored.}

\item{mile}{logical. `mile` specifies whether to return the output in miles instead of kilometers (by default, FALSE).}

\item{preprocess}{logical. `preprocess` specifies whether to first pick the potentially closest point.
It is recommended to set `preprocess = TRUE` if users need to obtain distances from many points.}

\item{input_crs}{the CRS of the focus points (defaults to 4326). These points are internally projected
to match the window CRS to ensure isotropic distance calculations.}

\item{unit_scale}{set to the same value as the parameter in `get_window()` function.
This parameter converts the coordinate values so that they alingn with the unit (km) of the owin object}
}
\value{
an im object
}
\description{
`get_dist_focus()` generates a distance map from focus locations.
}
