% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zshift.R
\name{zshift}
\alias{zshift}
\title{Offset Raster or Matrix Values}
\usage{
zshift(r, xdist = 0, ydist = 0, xrm, yrm, scale = FALSE)
}
\arguments{
\item{r}{A raster or matrix.}

\item{xdist}{Numeric indicating the number and direction (+, -)
of columns for the offset.}

\item{ydist}{Numeric indicating the number and direction (+, -)
of rows for the offset.}

\item{xrm}{Numeric value or vector indicating the number of
columns to be removed from the final matrix. If not set,
this value defaults to \code{xdist}. Positive values remove
columns from the right, while negative values remove columns
from the left. The absolute value of \code{xrm} must be
\code{>= abs(xdist)}.}

\item{yrm}{Numeric value or vector indicating the number
of rows to be removed from the final matrix. If not set,
this value defaults to \code{ydist}. Positive values remove
rows from the bottom, while negative values remove rows from
the top. The absolute value must be \code{>= abs(ydist)}.}

\item{scale}{Logical. Indicates whether or not to scale the values of
the raster.}
}
\value{
A numeric vector of values created from a matrix of the values
  with the specified offset. The vector is created from a matrix with
   \code{xrm} fewer columns and \code{yrm} fewer rows than the original
  raster value matrix.
}
\description{
Calculates a matrix of values with a negative
or positive, x or y, offset.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# remove right and bottom borders 2 deep
noborder <- zshift(normforest, xdist = 2, ydist = 2)
}
