% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DecayConstants.R
\docType{data}
\name{decayConstants}
\alias{decayConstants}
\title{Decay constants}
\format{
A data frame with 6 rows and the following
5 columns:\cr
\enumerate{
\item \code{name}  of the radioactive isotope -- element symbol and mass number
\item \code{value} it's value and
\item \code{err}   uncertainty as given by the reference. Uncertainty may be \code{NA} if not stated.
\item \code{unit}    of the decay -- usually per year (y), in some cases per day (d)
\item \code{refkey}  key to reference. Also makes the entry in this table unique if there is more than one decay constant per isotope
}

The following decay constants are included:\cr
\itemize{
\item Ar37
\item Ar39
\item K40
\item Rb87\cr
}

Some of them are included more than once in this table because their values
changed over time.
}
\usage{
decayConstants
}
\description{
A data set containing some decay constants regular used in earth science and geochronology.
}
\references{
{
\insertRef{Stoenner1965}{georefdatar}

\insertRef{Steiger1977}{georefdatar}

\insertRef{Renne2001}{georefdatar}

\insertRef{Renne2011}{georefdatar}

\insertRef{Villa2015}{georefdatar}
}
}
\keyword{datasets}
