% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{Finland}
\alias{Finland}
\title{Finnish lake data}
\description{
Table of 2327 Finnish lakes, extracted from a hydroLAKES database.
}
\examples{
data(Finland,package='geostats')
sf <- sizefrequency(Finland$area)
size <- sf[,'size']
freq <- sf[,'frequency']
plot(size,freq,log='xy')
fit <- lm(log(freq) ~ log(size))
lines(size,exp(predict(fit)))
}
\references{
Lehner, B., and Doll, P. (2004), Development and
    validation of a global database of lakes, reservoirs and
    wetlands, Journal of Hydrology, 296(1), 1-22, doi:
    10.1016/j.jhydrol.2004.03.028.
}
\keyword{data}
