% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.raster.from.asc.url.R
\name{read.raster.from.url}
\alias{read.raster.from.url}
\title{It imports a 'RasterLayer' object in Escri-Asci format from a URL 'http(s)://....<FILENAME>.asc}
\usage{
read.raster.from.url(x, header_nrow = 6, ...)
}
\arguments{
\item{x}{the charcater string containing the URL address}

\item{header_nrow}{Number of header in the ASCII grid format. Deafault is 6. See \url{https://en.wikipedia.org/wiki/Esri_grid}}

\item{...}{additional arguments}
}
\value{
a 'RasterLayer' object
}
\description{
It imports a 'RasterLayer' object in Escri-Asci format from a URL 'http(s)://....<FILENAME>.asc
}
\note{
This function reads a local or remote text files formatted as \url{https://en.wikipedia.org/wiki/Esri_grid} and creates a 'RasterLayer' object.
}
\seealso{
\code{\link[raster]{raster}},\code{\link{readLines}}
}
