% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_CVind.R
\name{random.CVind}
\alias{random.CVind}
\title{Cross validation index generator}
\usage{
random.CVind(n, ncmb, nval, CV)
}
\arguments{
\item{n}{Number of observations (rows).}

\item{ncmb}{Number of training samples for the SingBoost models in CMB. Must be an integer between 1 and \eqn{n}.}

\item{nval}{Number of validation samples in the CMB aggregation procedure. Must be an integer between 1 and \eqn{n-n_{cmb}-1}.}

\item{CV}{Number of cross validation steps. Must be a positive integer.}
}
\value{
\item{CVind}{List of row indices for training, validation and test data for each cross validation loop.}
}
\description{
{Simple auxiliary function for randomly generating the indices for training, validation and test data
for cross validation.}
}
\details{
{The data set consists of $n$ observations. \eqn{n_{cmb}} of them are used for the CMB aggregation procedure.
Note that within CMB itself, only a subset of these observations may be used for SingBoost training. The Stability
Selection is based on the validation set consisting of \eqn{n_{val}} observations. The cross-validated loss of the
final model is evaluated on the test data set with \eqn{n-n_{cmb}-n_{val}} observations. Clearly, all data sets need to
be disjoint.}
}
