% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_calendar_heatmap.R
\name{ggplot_calendar_heatmap}
\alias{ggplot_calendar_heatmap}
\title{Plots a calendar heatmap}
\usage{
ggplot_calendar_heatmap(dtDateValue, cDateColumnName = "",
  cValueColumnName = "", vcGroupingColumnNames = "Year",
  dayBorderSize = 0.25, dayBorderColour = "black",
  monthBorderSize = 2, monthBorderColour = "black",
  monthBorderLineEnd = "round")
}
\arguments{
\item{dtDateValue}{Data set which may include other columns apart from date
and values.}

\item{cDateColumnName}{Column name of the dates.}

\item{cValueColumnName}{Column name of the data.}

\item{vcGroupingColumnNames}{The set of columns which together define the group
for the chart to operate within If you plan to facet your plot,
you should specify the same column names to this argument. The function
will automatically add the veriable for the year to the facet.}

\item{dayBorderSize}{Size of the border around each day}

\item{dayBorderColour}{Colour of the border around each day}

\item{monthBorderSize}{Size of the border around each month}

\item{monthBorderColour}{Colour of the border around each month}

\item{monthBorderLineEnd}{Line end for the border around each month}
}
\value{
Returns a gpplot friendly object which means the user can use
ggplot scales to modify the look, add more geoms, etc.
}
\description{
A calendar heatmap provides context for weeks, and day of week which makes
it a better way to visualise daily data than line charts. Largely uses
Codoremifa's code from
stackoverflow.com/questions/22815688/calendar-time-series-with-r.
}
\section{Cosmetic Tips}{
 The minimalist look can be achieved by appending the
following chunk of code to the output object:
\code{
+
xlab(NULL) +
ylab(NULL) +
scale_fill_continuous(low = 'green', high = 'red') +
theme(
   axis.text = element_blank(),
   axis.ticks = element_blank(),
   legend.position = 'none',
   strip.background = element_blank(),
   # strip.text = element_blank(), # useful if only one year of data
   plot.background = element_blank(),
   panel.border = element_blank(),
   panel.background  = element_blank(),
   panel.grid = element_blank(),
   panel.border = element_blank()
)
}
}

\section{Also See}{
 \code{\link{stat_calendar_heatmap}}, a
flexible but less polished alternative.
}

\examples{
{
library(data.table)
library(ggplot2)
set.seed(1)
dtData = data.table(
      DateCol = seq(
         as.Date("1/01/2014", "\%d/\%m/\%Y"),
         as.Date("31/12/2015", "\%d/\%m/\%Y"),
         "days"
      ),
      ValueCol = runif(730)
   )
# you could also try categorical data with
# ValueCol = sample(c('a','b','c'), 730, replace = T)
p1 = ggplot_calendar_heatmap(
   dtData,
   'DateCol',
   'ValueCol'
)
p1
# add new geoms
p1 +
geom_text(label = '!!!') +
scale_colour_continuous(low = 'red', high = 'green')
}
}
