% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-geom-magick.R
\name{geom_magick}
\alias{geom_magick}
\title{Draw images as point shapes using magick}
\usage{
geom_magick(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  magick = NULL,
  magick_params = list(),
  interpolate = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{magick}{A function (purrr-style formula is accepted) that takes an
\code{\link[magick:editing]{image_read()}} object as input and returns an object
compatible with \code{\link[grDevices:as.raster]{as.raster()}}. You can use any of
the \verb{image_*()} functions from the \strong{magick} package to process the raster
image.}

\item{magick_params}{Additional arguments passed on to \code{magick}}

\item{interpolate}{
    A logical value indicating whether to linearly interpolate the
    image (the alternative is to use nearest-neighbour interpolation,
    which gives a more blocky result).
  }

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}
}
\description{
Reads an image with \strong{magick}, applies optional processing, and uses
the result as the graphical shape for points in a plot.

This is useful when you want to replace the usual point symbols
with arbitrary images while keeping full control over their placement,
size, and interpolation.
}
\examples{
set.seed(123)
d <- data.frame(
    x = rnorm(10),
    y = rnorm(10),
    image = "https://jeroenooms.github.io/images/frink.png",
    fill = sample(c("A", "B", "C", "D"), 10, replace = TRUE),
    alpha = rnorm(10, mean = 0.5, sd = 0.1)
)
d$alpha <- pmax(pmin(d$alpha, 1), 0)
ggplot(d, aes(x, y)) +
    geom_magick(aes(image = image, fill = fill, alpha = alpha))
}
\section{Aesthetics}{

\code{geom_magick()} understands the following aesthetics. Required aesthetics are displayed in bold and defaults are displayed for optional aesthetics:
\tabular{rll}{
 • \tab \strong{\code{\link[ggplot2:aes_position]{x}}} \tab   \cr
 • \tab \strong{\code{\link[ggplot2:aes_position]{y}}} \tab   \cr
 • \tab \strong{\code{image}} \tab   \cr
 • \tab \code{\link[ggplot2:aes_colour_fill_alpha]{alpha}} \tab → \code{NA} \cr
 • \tab \code{angle} \tab → \code{0} \cr
 • \tab \code{\link[ggplot2:aes_colour_fill_alpha]{fill}} \tab → \code{NA} \cr
 • \tab \code{\link[ggplot2:aes_group_order]{group}} \tab → inferred \cr
 • \tab \code{hjust} \tab → \code{0.5} \cr
 • \tab \code{\link[ggplot2:aes_linetype_size_shape]{size}} \tab → via \code{theme()} \cr
 • \tab \code{vjust} \tab → \code{0.5} \cr
}

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}
