% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-.R
\name{standardized_gtable}
\alias{standardized_gtable}
\title{Standardized gtable Representation}
\description{
The standardized gtable representation ensures that all plots share a
consistent row–column structure, facilitating flexible composition,
patch insertion, and alignment across multiple plots.

This layout provides a fixed-size gtable grid for predictable positioning
of plot components such as titles, axes, legends, captions, and margins.
It is used internally for layout normalization and patch-based alignment.
}
\section{Row structure (top -> bottom)}{
\tabular{lll}{
   Index \tab Component \tab Description \cr
   1 \tab \code{margin-top} \tab External top spacing \cr
   2 \tab \code{tag-top} \tab Top tag (e.g., "A", "B") \cr
   3 \tab \code{title} \tab Main title \cr
   4 \tab \code{subtitle} \tab Subtitle \cr
   5 \tab \code{guide-box-top} \tab Legend box at top \cr
   6 \tab \code{legend.box.spacing} \tab Space between legend and main area \cr
   7 \tab \code{patch-title-top} \tab Top patch title \cr
   8 \tab \code{xlab-top} \tab Top x-axis label (rare) \cr
   9 \tab \code{axis-top} \tab Top axis ticks and labels \cr
   10 \tab \code{strip-top} \tab Top strip (facet label) \cr
   11 \tab \code{panel} \tab Main plotting panel \cr
   12 \tab \code{strip-bottom} \tab Bottom strip (facet label) \cr
   13 \tab \code{axis-bottom} \tab Bottom axis ticks and labels \cr
   14 \tab \code{xlab-bottom} \tab Bottom x-axis label \cr
   15 \tab \code{patch-title-bottom} \tab Top patch title \cr
   16 \tab \code{legend.box.spacing} \tab Space before bottom legend box \cr
   17 \tab \code{guide-box-bottom} \tab Bottom legend box \cr
   18 \tab \code{caption} \tab Caption or footnote text \cr
   19 \tab \code{tag-bottom} \tab Bottom tag (optional) \cr
   20 \tab \code{margin-bottom} \tab External bottom spacing \cr
}
}

\section{Column structure (left -> right)}{
\tabular{lll}{
   Index \tab Component \tab Description \cr
   1 \tab \code{margin-left} \tab External left spacing \cr
   2 \tab \code{tag-left} \tab Optional side tag \cr
   3 \tab \code{guide-box-left} \tab Left legend box \cr
   4 \tab \code{legend.box.spacing} \tab Space between legend and panel \cr
   5 \tab \code{patch-title-left} \tab Left patch title \cr
   6 \tab \code{ylab-left} \tab Left y-axis label \cr
   7 \tab \code{axis-left} \tab Left axis ticks and labels \cr
   8 \tab \code{strip-left} \tab Left strip (facet label) \cr
   9 \tab \code{panel} \tab Main panel area \cr
   10 \tab \code{strip-right} \tab Right strip (facet label) \cr
   11 \tab \code{axis-right} \tab Right axis ticks and labels \cr
   12 \tab \code{ylab-right} \tab Right y-axis label \cr
   13 \tab \code{patch-title-right} \tab Right patch title \cr
   14 \tab \code{legend.box.spacing} \tab Space before right legend box \cr
   15 \tab \code{guide-box-right} \tab Right legend box \cr
   16 \tab \code{tag-right} \tab Optional tag on right side \cr
   17 \tab \code{margin-right} \tab External right spacing \cr
}
}

\keyword{internal}
