% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SVD.R
\name{get_SVD}
\alias{get_SVD}
\title{Extract the SVD components from a PCA-like object}
\usage{
get_SVD(pcobj)
}
\arguments{
\item{pcobj}{an object returned by \code{\link[stats]{prcomp}}, \code{\link[stats]{princomp}}, 
\code{\link[FactoMineR]{PCA}}, \code{\link[ade4]{dudi.pca}}, or \code{\link[MASS]{lda}}}
}
\value{
A list of four elements
  \describe{
    \item{n}{The sample size on which the analysis was based}
    \item{U}{Left singular vectors, giving observation scores}
    \item{D}{vector of singular values, the diagonal elements of the matrix \eqn{\mathbf{D}}, which are also the square roots
        of the eigenvalues of \eqn{\mathbf{X} \mathbf{X}'}}
    \item{V}{Right singular vectors, giving variable loadings}
  }
}
\description{
Biplots are based on the Singular Value Decomposition, which for a data matrix is
\deqn{\mathbf{X} / \sqrt{n} = \mathbf{U} \mathbf{D} \mathbf{V}^T}
but these are computed and returned in quite different
forms by various PCA-like methods. This function provides a common interface, returning
the components with standard names.
}
\examples{
data(crime)
crime.pca <- 
  crime |> 
  dplyr::select(where(is.numeric)) |>
  prcomp(scale. = TRUE)

crime.svd <- get_SVD(crime.pca)
names(crime.svd)
crime.svd$D

}
