% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_rampbar.R
\name{guide_rampbar}
\alias{guide_rampbar}
\title{Continuous guide for colour ramp scales (ggplot2 guide)}
\usage{
guide_rampbar(
  ...,
  to = "gray65",
  available_aes = c("fill_ramp", "colour_ramp")
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:guide_colourbar]{ggplot2::guide_colourbar}}
  \describe{
    \item{\code{title}}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}
    \item{\code{theme}}{A \code{\link[ggplot2:theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides, and is combined with, the plot's theme.}
    \item{\code{nbin}}{A numeric specifying the number of bins for drawing the
colourbar. A smoother colourbar results from a larger value.}
    \item{\code{display}}{A string indicating a method to display the colourbar. Can be
one of the following:
\itemize{
\item \code{"raster"} to display as a bitmap image.
\item \code{"rectangles"} to display as a series of rectangles.
\item \code{"gradient"} to display as a linear gradient.
}

Note that not all devices are able to render rasters and gradients.}
    \item{\code{raster}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}  A logical. If \code{TRUE} then
the colourbar is rendered as a raster object. If \code{FALSE} then the colourbar
is rendered as a set of rectangles. Note that not all graphics devices are
capable of rendering raster image.}
    \item{\code{alpha}}{A numeric between 0 and 1 setting the colour transparency of
the bar. Use \code{NA} to preserve the alpha encoded in the colour itself
(default).}
    \item{\code{draw.ulim}}{A logical specifying if the upper limit tick marks should
be visible.}
    \item{\code{draw.llim}}{A logical specifying if the lower limit tick marks should
be visible.}
    \item{\code{position}}{A character string indicating where the legend should be
placed relative to the plot panels.}
    \item{\code{direction}}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}
    \item{\code{reverse}}{logical. If \code{TRUE} the colourbar is reversed. By default,
the highest value is on the top and the lowest value is on the bottom}
    \item{\code{order}}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}
  }}

\item{to}{<\link[=character]{string}> The color to ramp to in the guide. Corresponds to \code{1} on the scale.}

\item{available_aes}{<\link{character}> Vector listing the aesthetics for which a \code{guide_rampbar()} can be drawn.}
}
\value{
A guide object.
}
\description{
A colour ramp bar guide that shows continuous colour ramp scales mapped onto
values as a smooth gradient. Designed for use with \code{\link[=scale_fill_ramp_continuous]{scale_fill_ramp_continuous()}}
and \code{\link[=scale_colour_ramp_continuous]{scale_colour_ramp_continuous()}}. Based on \code{\link[ggplot2:guide_colourbar]{guide_colourbar()}}.
}
\details{
This guide creates smooth gradient color bars for use with \code{\link[=scale_fill_ramp_continuous]{scale_fill_ramp_continuous()}}
and \code{\link[=scale_colour_ramp_continuous]{scale_colour_ramp_continuous()}}. The color to ramp from is determined by the \code{from}
argument of the \verb{scale_*} function, and the color to ramp to is determined by the \code{to} argument
to \code{\link[=guide_rampbar]{guide_rampbar()}}.

Guides can be specified in each \verb{scale_*} function or in \code{guides()}.
\code{guide = "rampbar"} in \verb{scale_*} is syntactic sugar for \code{guide = guide_rampbar()};
e.g. \code{scale_colour_ramp_continuous(guide = "rampbar")}. For how to specify
the guide for each scale in more detail, see \code{guides()}.
}
\examples{

library(dplyr)
library(ggplot2)
library(distributional)

# The default guide for ramp scales is guide_legend(), which creates a
# discrete style scale:
tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = after_stat(x)), fill = "blue") +
  scale_fill_ramp_continuous(from = "red")

# We can use guide_rampbar() to instead create a continuous guide, but
# it does not know what color to ramp to (defaults to "gray65"):
tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = after_stat(x)), fill = "blue") +
  scale_fill_ramp_continuous(from = "red", guide = guide_rampbar())

# We can tell the guide what color to ramp to using the `to` argument:
tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = after_stat(x)), fill = "blue") +
  scale_fill_ramp_continuous(from = "red", guide = guide_rampbar(to = "blue"))

}
\seealso{
Other colour ramp functions: 
\code{\link{partial_colour_ramp}()},
\code{\link{ramp_colours}()},
\code{\link{scale_colour_ramp}}
}
\author{
Matthew Kay
}
\concept{colour ramp functions}
