% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_key_fields.r
\name{draw_key_fields}
\alias{draw_key_fields}
\title{Key glyphs for 'radius' legends}
\usage{
draw_key_fields(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A grid grob
}
\description{
Each geom has an associated function that draws the key when the geom needs
to be displayed in a legend. These functions are called \verb{draw_key_*()}, where
\code{*} stands for the name of the respective key glyph. The key glyphs can be
customized for individual geoms by providing a geom with the \code{key_glyph}
argument (see \code{\link[ggplot2:layer]{layer()}} or examples below.)
}
\details{
The layer \code{\link[=geom_fields]{geom_fields()}} allows for a special aesthetic \code{radius}. This function
draws a key glyph for this aesthetics, where the radius of the arrow corresponds
with the scalar value listed with this radius. Note that the width of the key glyph
cannot be adjusted by the aesthetic itself. Therefore, if your \code{max_radius} parameter
exceeds the glyph width, you need to change the width of the guides yourself,
see \code{vignette("radius_aes")} for more details.
}
\examples{
if (requireNamespace("ggplot2")) {
  library(ggplot2)
  p <- ggplot(economics, aes(date, psavert, color = "savings rate"))
  p + geom_line(key_glyph = "fields")
}
}
\author{
Pepijn de Vries
}
