% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-intervals.r
\name{geom_lineranges}
\alias{geom_lineranges}
\alias{geom_pointranges}
\title{Intervals depicting ranges, usually about center points}
\usage{
geom_lineranges(
  mapping = NULL,
  data = NULL,
  stat = "center",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_pointranges(
  mapping = NULL,
  data = NULL,
  stat = "center",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{na.rm}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
\code{geom_lineranges()} renders horizontal and vertical intervals
for a specified subject or variable; \code{geom_pointranges()} additionally
renders a point at their crosshairs.
}
\details{
The \code{geom_*ranges()} layers are shortcuts for equivalently-specified
pairs of horizontal and vertical
\code{\link[ggplot2:geom_linerange]{ggplot2::geom_*range()}} layers. Rather than
\code{\link[ggplot2:stat_identity]{ggplot2::stat_identity()}}, they default to \code{\link[=stat_center]{stat_center()}}, so that in
practice the summary values do not need to be manually passed.
}
\section{Aesthetics}{

\code{geom_lineranges()} and \code{geom_pointranges()} understand the following
aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{xmin}}
\item \strong{\code{xmax}}
\item \strong{\code{y}}
\item \strong{\code{ymin}}
\item \strong{\code{ymax}}`
\item \code{alpha}
\item \code{colour}
\item \code{linewidth}
\item \code{linetype}
\item \code{size}
\item \code{group}
}
}

\examples{
ggplot(mpg, aes(x = displ, y = hwy, color = drv)) +
  geom_point(alpha = .25) +
  geom_lineranges()

if (require(Hmisc)) {
  ggplot(mpg, aes(x = displ, y = hwy, color = drv)) +
    geom_point(alpha = .25) +
    geom_pointranges(fun.data = mean_sdl, shape = "circle open")
}

mpg \%>\% 
  aggregate(
    x = cbind(displ, hwy) ~ 0,
    FUN = function(z) c(min = min(z), med = median(z), max = max(z))
  ) \%>\% 
  do.call(what = data.frame) \%>\% 
  ggplot(aes(displ.med, hwy.med)) +
  geom_pointranges(
    stat = "identity",
    aes(xmin = displ.min, xmax = displ.max, ymin = hwy.min, ymax = hwy.max)
  ) +
  geom_point(data = mpg, aes(displ, hwy), alpha = .5)
}
\seealso{
Other geom layers: 
\code{\link{geom_axis}()},
\code{\link{geom_bagplot}()},
\code{\link{geom_isoline}()},
\code{\link{geom_rule}()},
\code{\link{geom_text_radiate}()},
\code{\link{geom_vector}()}
}
\concept{geom layers}
