% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-rule.r
\name{stat_rule}
\alias{stat_rule}
\alias{minpp}
\alias{maxpp}
\alias{minabspp}
\title{Construct limited rules offset from the origin}
\usage{
stat_rule(
  mapping = NULL,
  data = NULL,
  geom = "rule",
  position = "identity",
  fun.lower = "minpp",
  fun.upper = "maxpp",
  fun.offset = "minabspp",
  fun.args = list(),
  referent = NULL,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

minpp(x, p = 0.1)

maxpp(x, p = 0.1)

minabspp(x, p = 0.1)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{fun.lower, fun.upper, fun.offset}{Functions used to determine the limits
of the rules and the translations of the axes from the projections of
\code{referent} onto the axes and onto their normal vectors.}

\item{fun.args}{Optional additional arguments passed on to the functions.}

\item{referent}{The reference data set; see Details.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{x}{A numeric vector.}

\item{p}{A numeric value; the proportion of a range used as a buffer.}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
Determine axis limits and offset vectors from reference data.
}
\details{
Biplots with several axes can become cluttered and illegible. When this
happens, Gower, Gardner--Lubbe, & le Roux (2011) recommend to translate the
axes to a new point of intersection away from the origin, adjusting the axis
markers accordingly. Then the axes converge in a region of the plot offset
from most position markers or other elements. An alternative solution,
implemented in the \strong{bipl5} package
(\url{https://github.com/RuanBuys/bipl5}), is to translate each axis
orthogonally away from the origin, which preserves the axis markers. This is
the technique implemented here.

Separately, axes that fill the plotting window are uninformative when they
exceed the range of the plotted position markers projected onto them. They
may even be misinformative, suggesting that linear relationships extrapolate
outside the data range. In these cases, Gower and Harding (1988) recommend
using finite ranges determined by the data projection onto each axis.

Three functions control these operations: \code{fun.offset} computes the
orthogonal distance of each axis from the origin, and \code{fun.lower} and
\code{fun.upper} compute the distance along each axis of the endpoints to the
(offset) origin. Both functions depend on what position data is to be offset
from or limited to, which must be passed manually to the \code{referent}
parameter.
}
\section{Referential stats}{

This statistical transformation is done with respect to reference data passed
to \code{referent} (ignored if \code{NULL}, the default, possibly resulting in empty
output). See \code{\link[=stat_referent]{stat_referent()}} for more details. This relies on a sleight of
hand through a new undocumented \code{LayerRef} class and associated
\code{\link[ggplot2:ggplot_add]{ggplot2::ggplot_add()}} method. As a result, only layers constructed using
this \verb{stat_*()} shortcut will pass the necessary positional aesthetics to the
\verb{$setup_params()} step, making them available to pre-process \code{referent} data.

The biplot shortcuts automatically substitute the complementary matrix factor
for \code{referent = NULL} and will use an integer vector to select a subset from
this factor. These uses do not require the mapping passage.
}

\section{Computed variables}{
 These are calculated during the statistical
transformation and can be accessed with \link[ggplot2:aes_eval]{delayed evaluation}.
\describe{
\item{\code{axis}}{unique axis identifier (integer)}
\item{\verb{lower,upper}}{distances to endpoints from origin (before offset)}
\item{\verb{yintercept,xintercept}}{intercepts (possibly \code{Inf}) of offset axis}
}
}

\examples{
# stack loss gradient
stackloss \%>\% 
  lm(formula = stack.loss ~ Air.Flow + Water.Temp + Acid.Conc.) \%>\% 
  coef() \%>\% 
  as.list() \%>\% as.data.frame() \%>\% 
  subset(select = c(Air.Flow, Water.Temp, Acid.Conc.)) ->
  coef_data
# gradient rule with respect to two predictors
stackloss_centered <- scale(stackloss, scale = FALSE)
stackloss_centered \%>\% 
  ggplot(aes(x = Acid.Conc., y = Air.Flow)) +
  coord_square() +
  geom_point(aes(size = stack.loss, alpha = sign(stack.loss))) + 
  scale_size_area() + scale_alpha_binned(breaks = c(-1, 0, 1)) +
  stat_rule(
    geom = "axis",
    data = coef_data,
    referent = stackloss_centered,
    fun.offset = function(x) minabspp(x, p = .5)
  )
}
\references{
Gower JC, Gardner--Lubbe S, & le Roux NJ (2011) \emph{Understanding Biplots}.
Wiley, ISBN: 978-0-470-01255-0. \url{https://www.wiley.com/go/biplots}

Gower JC & Harding SA (1988) "Nonlinear biplots". \emph{Biometrika} \strong{75}(3):
445--455. \doi{10.1093/biomet/75.3.445}
}
\seealso{
Other stat layers: 
\code{\link{stat_bagplot}()},
\code{\link{stat_center}()},
\code{\link{stat_chull}()},
\code{\link{stat_cone}()},
\code{\link{stat_depth}()},
\code{\link{stat_scale}()},
\code{\link{stat_spantree}()}
}
\concept{stat layers}
