% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPredict.R
\name{ggPredict}
\alias{ggPredict}
\title{Visualize predictions from the multiple regression models.}
\usage{
ggPredict(
  fit,
  colorn = 4,
  point = NULL,
  jitter = NULL,
  se = FALSE,
  show.summary = FALSE,
  colorAsFactor = FALSE,
  digits = 2,
  interactive = FALSE,
  ...
)
}
\arguments{
\item{fit}{a model object for which prediction is desired.}

\item{colorn}{Integer. Number of subgroups of color variables.}

\item{point}{Logical. Whether or not draw each point}

\item{jitter}{Logical. Whether or not jitter points}

\item{se}{Logical. Whether or not draw se}

\item{show.summary}{Logical. Whether or not show summary}

\item{colorAsFactor}{Logical. Whether or not treat color variable as categorical variable}

\item{digits}{An integer indicating the number of decimal places}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{...}{additional arguments affecting the predictions produced.}
}
\description{
Visualize predictions from the multiple regression models.
}
\examples{
require(moonBook)
require(ggplot2)
require(ggiraph)
require(plyr)
fit=lm(NTAV~age*weight,data=radial)
fit=lm(NTAV~age*weight*DM,data=radial)
fit=lm(NTAV~age+DM,data=radial)
ggPredict(fit,interactive=TRUE)
require(TH.data)
fit=glm(cens~pnodes*horTh,data=GBSG2,family=binomial)
ggPredict(fit,se=TRUE)
fit1=glm(cens~pnodes*age,data=GBSG2,family=binomial)
ggPredict(fit1)
ggPredict(fit1,colorn=100,jitter=FALSE,interactive=TRUE)
fit2=glm(cens~pnodes*age*horTh,data=GBSG2,family=binomial)
ggPredict(fit2,colorn=100,jitter=FALSE,interactive=TRUE)
}
