% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_scale_location.R
\name{stat_scale_location}
\alias{stat_scale_location}
\title{stat_scale_location}
\usage{
stat_scale_location(
  alpha = 0.5,
  na.rm = TRUE,
  se = FALSE,
  method = "loess",
  color = "steelblue",
  ...
)
}
\arguments{
\item{alpha}{Adjust the transparency of points.}

\item{na.rm}{Remove points with value NA?}

\item{se}{Keep standard error bands around line?}

\item{method}{Method for fitting the line to the points.}

\item{color}{Color of the line.}

\item{...}{Currently ignored. For extendability.}
}
\value{
A `ggplot2` layer for plotting the scale location diagnostic plot.
}
\description{
Scale location diagnostic plot.
}
\examples{
data(mtcars)
model <- lm(mpg ~ cyl + disp + hp, data = mtcars)
ggplot2::ggplot(data = model) + stat_scale_location()
}
