% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensors.R
\name{ggml_set_zero}
\alias{ggml_set_zero}
\title{Set Tensor to Zero}
\usage{
ggml_set_zero(tensor)
}
\arguments{
\item{tensor}{Tensor to zero out}
}
\value{
NULL (invisible)
}
\description{
Sets all elements of a tensor to zero.
This is more efficient than manually setting all elements.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
t <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
ggml_set_f32(t, 1:10)
ggml_set_zero(t)
ggml_get_f32(t)
ggml_free(ctx)
}
}
