% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_layers.R
\name{ag_batch_norm}
\alias{ag_batch_norm}
\title{Create a Batch Normalisation layer}
\usage{
ag_batch_norm(num_features, eps = 1e-05, momentum = 0.1)
}
\arguments{
\item{num_features}{Number of features (rows of input)}

\item{eps}{Numerical stability constant (default 1e-5)}

\item{momentum}{Running-stats momentum (default 0.1)}
}
\value{
An \code{ag_batch_norm} environment
}
\description{
Normalises each feature (row) over the batch dimension.
Learnable scale \code{gamma} [F,1] and shift \code{beta} [F,1].
}
\details{
\strong{Training mode}: use batch statistics; update running mean/var.
\strong{Eval mode}: use stored running statistics.
}
\examples{
\donttest{
bn <- ag_batch_norm(16L)
x  <- ag_tensor(matrix(rnorm(16 * 32), 16, 32))
out <- bn$forward(x)
}
}
