% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R, R/nn_model.R
\name{ggml_compile.ggml_functional_model}
\alias{ggml_compile.ggml_functional_model}
\alias{ggml_compile}
\alias{ggml_compile.ggml_sequential_model}
\title{Compile a Sequential Model}
\usage{
\method{ggml_compile}{ggml_functional_model}(
  model,
  optimizer = "adam",
  loss = "categorical_crossentropy",
  metrics = c("accuracy"),
  backend = "auto"
)

ggml_compile(
  model,
  optimizer = "adam",
  loss = "categorical_crossentropy",
  metrics = c("accuracy"),
  backend = "auto"
)

\method{ggml_compile}{ggml_sequential_model}(
  model,
  optimizer = "adam",
  loss = "categorical_crossentropy",
  metrics = c("accuracy"),
  backend = "auto"
)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{optimizer}{Optimizer name: "adam" or "sgd"}

\item{loss}{Loss function name: "categorical_crossentropy" or "mse"}

\item{metrics}{Character vector of metrics (currently "accuracy")}

\item{backend}{Backend to use: "auto" (GPU if available, else CPU), "cpu", or "vulkan"}
}
\value{
The compiled model (invisibly).
}
\description{
Configures the model for training: infers shapes, creates backend.
Weight tensors are created at training time when batch_size is known.
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_conv_2d(32, c(3,3), activation = "relu",
                     input_shape = c(28, 28, 1)) |>
  ggml_layer_max_pooling_2d(c(2, 2)) |>
  ggml_layer_flatten() |>
  ggml_layer_dense(10, activation = "softmax")
model <- ggml_compile(model, optimizer = "adam",
                      loss = "categorical_crossentropy")
}
}
