% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcp_arrange.r
\name{pcp_arrange}
\alias{pcp_arrange}
\title{Data wrangling for GPCPs: Step 3 order observations in factor variables}
\usage{
pcp_arrange(data, method = "from-right", space = 0.05, .by_group = TRUE)
}
\arguments{
\item{data}{data frame - preferably processed using \code{pcp_select} and \code{pcp_scale}.}

\item{method}{method for breaking ties, one of "from-right", "from-left" or "from-both".}

\item{space}{number between 0 and 1, indicating the proportion of space used for separating multiple levels.}

\item{.by_group}{logical value. If TRUE, scaling will respect any previous grouping variables. Applies to grouped data frames only.}
}
\value{
data frame of the same size as the input data; values of \code{pcp_y} and
\code{pcp_yend} are adjusted for \code{pcp_class} == "factor"
}
\description{
Break ties for levels in factor variables, space cases out equally and set an order.
Note that only ties in \strong{factor} variables are addressed this way.
}
\details{
The data pipeline feeding any of the geom layers in the \code{ggpcp} package is implemented in a three-step modularized
form rather than as the stat functions more typical for \code{ggplot2} extensions.
The three steps of data pre-processing are:\tabular{ll}{
   \strong{command} \tab \strong{data processing step} \cr
   \code{pcp_select} \tab variable selection (and horizontal ordering) \cr
   \code{pcp_scale} \tab (vertical) scaling of values \cr
   \code{pcp_arrange} \tab dealing with tie-breaks on categorical axes \cr
}


Note that these data processing steps are executed before the call to \code{ggplot2}
and the identity function is used by default in all of the \code{ggpcp} specific layers.
Besides the speed-up by only executing the processing steps once for all layers,
the separation has the additional benefit, that it provides the users with the
possibility to make specific choices at each step in the process. Additionally,
separation allows for a cleaner user interface: parameters affecting the data
preparation process can be moved to the relevant (set of) function(s) only, thereby
reducing the  number of arguments without any loss of functionality.
}
\examples{
library(ggplot2)
data(Carcinoma)
# select scores
pcp_data <- Carcinoma |>
  pcp_select(A:G) |>
  pcp_scale()

# y values are on five different values
table(pcp_data$pcp_y)

# spread out y values
pcp_data  |> pcp_arrange() |>
  ggplot(aes(x = pcp_y)) + geom_histogram(binwidth=0.05)
}
\seealso{
\code{\link[=pcp_select]{pcp_select()}}, \code{\link[=pcp_scale]{pcp_scale()}}
}
