% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmodel2-util.R
\name{coef.lmodel2}
\alias{coef.lmodel2}
\title{Extract Model Coefficients}
\usage{
\method{coef}{lmodel2}(object, method = "MA", ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{method}{character One of the methods available in \code{object}.}

\item{...}{ignored by this method.}
}
\value{
A named numeric vector of length two.
}
\description{
\code{coef} is a generic function which extracts model coefficients from
objects returned by modeling functions. \code{coefficients} is an alias for
it.
}
\details{
Function \code{lmodel2()} from package 'lmodel2' returns a fitted
  model object of class \code{"lmodel2"} which differs from that returned by
  \code{lm()}. Here we implement a \code{coef()} method for objects of this
  class. It differs from de generic method and that for lm objects in having
  an additional formal parameter \code{method} that must be used to select
  estimates based on which of the methods supported by \code{lmodel2()} are
  to be extracted. The returned object is identical in its structure to that
  returned by \code{coef.lm()}.
}
\seealso{
\code{\link[lmodel2]{lmodel2}}
}
