% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrmix-helper-fun.R
\name{distrmix_helper_fun}
\alias{distrmix_helper_fun}
\title{Helper function for fitting Normal mixture model}
\usage{
distrmix_helper_fun(
  data,
  aes.name = "x",
  method,
  method.name,
  se,
  method.args = list(),
  k = 2,
  free.mean = TRUE,
  free.sd = TRUE,
  n.min = 10L * k,
  fit.seed = NA,
  fm.values = TRUE,
  verbose = getOption("verbose", default = FALSE)
)
}
\arguments{
\item{data}{A layer specific dataset, only needed if you want to override the
plot defaults.}

\item{method}{function or character If character, "normalmixEM"
or the name of a model fit function are accepted, possibly followed by the
fit function's \code{method} argument separated by a colon. The function
must return a model fit object of class \code{mixEM}.}

\item{se}{Currently ignored.}

\item{method.args}{named list with additional arguments.}

\item{k}{integer Number of mixture components to fit.}

\item{free.mean, free.sd}{logical If TRUE, allow the fitted \code{mean} and/or
fitted \code{sd} to vary among the component Normal distributions.}

\item{n.min}{integer Minimum number of distinct values in the mapped
variable for fitting to the attempted.}

\item{fit.seed}{RNG seed argument passed to \code{\link[base:Random]{set.seed}()}.
Defaults to \code{NA}, which means that \code{set.seed()} will not be
called.}

\item{fm.values}{logical Add parameter estimates and their standard errors
to the returned values (`FALSE` by default.)}

\item{verbose}{If FALSE, capture screen output from method and display it
as a \code{message()} only in case of conversion failure.}
}
\description{
Factored out code used in both stat_distrmix_line() and stat_distrmix_eq().
}
\details{
This function does the model fitting and returns a data frame with the
estimates for the parameters. It is a wrapper on functions from package
'mixtools'.
}
\keyword{internal}
