% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-dodge-nudge-to.R,
%   R/position-dodge2nudge-to.R
\name{position_dodgenudge_to}
\alias{position_dodgenudge_to}
\alias{position_dodge2nudge_to}
\title{Dodge plus nudge labels to new positions}
\usage{
position_dodgenudge_to(
  width = 1,
  preserve = c("total", "single"),
  reverse = FALSE,
  x = NULL,
  y = NULL,
  x.action = c("none", "spread"),
  y.action = c("none", "spread"),
  x.distance = "equal",
  y.distance = "equal",
  x.expansion = 0,
  y.expansion = 0,
  kept.origin = c("dodged", "original", "none")
)

position_dodge2nudge_to(
  width = 1,
  preserve = c("total", "single"),
  padding = 0.1,
  reverse = FALSE,
  x = NULL,
  y = NULL,
  x.action = c("none", "spread"),
  y.action = c("none", "spread"),
  x.distance = "equal",
  y.distance = "equal",
  x.expansion = 0,
  y.expansion = 0,
  kept.origin = c("dodged", "original", "none")
)
}
\arguments{
\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms. See the examples.}

\item{preserve}{Should dodging preserve the total width of all elements at a
position, or the width of a single element?.}

\item{reverse}{If TRUE, will reverse the default dodging order.}

\item{x, y}{Coordinates of the destination position. A vector of mode
\code{numeric}, that is extended if needed, to the same length as rows
there are in \code{data}. The default, \code{NULL}, leaves the original
coordinates unchanged after dodging.}

\item{x.action, y.action}{character string, one of \code{"none"}, or
\code{"spread"}. With \code{"spread"} distributing the positions
within the range of argument \code{x} or \code{y}, if non-null, or the
range the variable mapped to \emph{x} or \code{y}, otherwise.}

\item{x.distance, y.distance}{character or numeric Currently only \code{"equal"} is
implemented.}

\item{x.expansion, y.expansion}{numeric vectors of length 1 or 2, as a
fraction of width of the range.}

\item{kept.origin}{One of \code{"original"}, \code{"dodged"} or
\code{"none"}.}

\item{padding}{Padding between elements at the same position. Elements are
shrunk by this proportion to allow space between them. Defaults to 0.1.}
}
\value{
A \code{"Position"} object.
}
\description{
Functions \code{position_dodgenudge_to()} and
\code{position_dodge2nudge_to()} are meant to complement
\code{position_dodge()} and \code{position_dodge2()} from 'ggplot2', adding
as a second action that of \code{position_nudge_to()}. These positions are
generally useful for adjusting the position of labels or text. As with other
position functions in this package, the original positions are preserved to
allow the text or labels to be linked back to their original position with a
segment or arrow.
}
\details{
These positions apply sequentially two actions, in the order they
  appear in their names. The applied dodge is similar to that by
  \code{\link[ggplot2]{position_dodge}} and
  \code{\link[ggplot2]{position_dodge2}} while nudging is different to that
  by \code{\link[ggplot2]{position_nudge}} and equal to that applied by
  \code{\link{position_nudge_to}}.

  The dodged and nudged to \code{x} and/or \code{y} values replace the
  original ones in \code{data}, while the original or the dodged coordinates
  are returned in \code{x_orig} and \code{y_orig}. Nudge values supported are
  those of \emph{mode} numeric, thus including dates and times when they
  match the mapped data.

  If the length of \code{x} and/or \code{y} is more than one but less than
  rows are present in the data, the vector is both recycled and reordered so
  that the nudges are applied sequentially based on the data values. If their
  length matches the number of rows in data, they are assumed to be already
  in data order.

  The intended use is to label dodged bars, boxplots or points with labels
  aligned. In this case, it is mandatory to use the same argument to
  \code{width} when passing \code{position_dodge()} to \code{geom_col()} and
  \code{position_dodgenudge_to()} to \code{geom_text()}, \code{geom_label()},
  \code{geom_text_s()}, \code{geom_label_s()} or their repulsive equivalents
  from package 'ggrepel'. Otherwise the arrows or segments will fail to
  connect to the labels.

  When applying dodging, the return of original positions instead of the
  dodged ones is achieved by passing \code{origin = "original"} instead of
  the default of \code{origin = "dodged"}.
}
\note{
Irrespective of the action, the ordering of rows in \code{data} is
  preserved.
}
\examples{

df <- data.frame(
  x = c(1,3,2,5,4,2.5),
  y = c(2, 3, 2.5, 1.8, 2.8, 1.5),
  grp = c("A", "A", "A", "B", "B", "B"),
  grp.inner = c("a", "b", "c", "a", "b", "c"),
  label = c("abc","cd","d","c","bcd","a")
)

# default is no nudging
ggplot(df, aes(grp, y, label = label, fill = label)) +
  geom_col(position = position_dodge(width = 0.92)) +
  geom_text(position = position_dodgenudge_to(width = 0.92),
            vjust = -0.2) +
  theme(legend.position = "none")

ggplot(df, aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge(width = 0.92)) +
  geom_text(position = position_dodgenudge_to(width = 0.92),
            vjust = -0.2)

ggplot(df, aes(grp, y, label = label, fill = label)) +
  geom_col(position = position_dodge2(width = 0.92)) +
  geom_text(position = position_dodge2nudge_to(width = 0.92),
            vjust = -0.2) +
  theme(legend.position = "none")

ggplot(df, aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge2(width = 0.92)) +
  geom_text(position = position_dodge2nudge_to(width = 0.92),
            vjust = -0.2)

# nudging all labels to a given y value
ggplot(df, aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge(width = 0.92)) +
  geom_text(position = position_dodgenudge_to(width = 0.92, y = 0.8))

ggplot(df, aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge2(width = 0.92)) +
  geom_text(position = position_dodge2nudge_to(width = 0.92, y = 0.8))

ggplot(df, aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge(width = 0.92)) +
  geom_text(position = position_dodgenudge_to(width = 0.92, y = 0.8))

ggplot(df[-1, ], aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge(width = 0.92)) +
  geom_text(position = position_dodgenudge_to(width = 0.92, y = 0.8))

ggplot(df[-1, ], aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge(width = 0.92, preserve = "total")) +
  geom_text(position = position_dodgenudge_to(width = 0.92, y = 0.8,
                                              preserve = "total"))

ggplot(df[-1, ], aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge(width = 0.92, preserve = "single")) +
  geom_text(position = position_dodgenudge_to(width = 0.92, y = 0.8,
                                              preserve = "single"))

ggplot(df[-1, ], aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge2(width = 0.92, preserve = "total")) +
  geom_text(position = position_dodge2nudge_to(width = 0.92, y = 0.8,
                                              preserve = "total"))

ggplot(df[-1, ], aes(grp, y, label = label, fill = grp.inner)) +
  geom_col(position = position_dodge2(width = 0.92, preserve = "single")) +
  geom_text(position = position_dodge2nudge_to(width = 0.92, y = 0.8,
                                              preserve = "single"))

}
\seealso{
\code{\link{position_nudge_to}},
  \code{\link[ggplot2]{position_dodge}},
  \code{\link[ggplot2]{position_dodge2}}.

Other position adjustments: 
\code{\link{position_dodgenudge}()},
\code{\link{position_jitternudge}()},
\code{\link{position_nudge_center}()},
\code{\link{position_nudge_keep}()},
\code{\link{position_nudge_line}()},
\code{\link{position_nudge_to}()},
\code{\link{position_stacknudge}()},
\code{\link{position_stacknudge_to}()}
}
\concept{position adjustments}
