% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-point-linked.r
\name{geom_point_s}
\alias{geom_point_s}
\title{Points linked by a segment}
\usage{
geom_point_s(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  nudge_x = 0,
  nudge_y = 0,
  move.point = TRUE,
  arrow = grid::arrow(length = unit(1/3, "lines"), ends = "first"),
  default.colour = NULL,
  default.color = default.colour,
  colour.target = "point",
  color.target = colour.target,
  default.alpha = NA,
  alpha.target = "all",
  add.segments = TRUE,
  box.padding = 0.25,
  point.padding = 1e-06,
  segment.linewidth = 0.5,
  min.segment.length = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by
\code{\link[ggplot2]{aes}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
are three types of arguments you can use here:
\itemize{ \item Aesthetics: to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. \item Other arguments to the
layer, for example you override the default \code{stat} associated with the
layer. \item Other arguments passed on to the stat. }}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{move.point}{logical If \code{TRUE} the point is drawn at the nudged
position while if \code{FALSE} the point is drawn at the original position.}

\item{arrow}{specification for arrow heads, as created by
\code{\link[grid]{arrow}}}

\item{default.colour, default.color}{A colour definition to use for elements not targeted by
the colour aesthetic.}

\item{colour.target, color.target}{A character string, one of \code{"all"},
\code{"point"} and \code{"segment"} or \code{"none"}.}

\item{default.alpha}{numeric in [0..1] A transparency value to use for
elements not targeted by the alpha aesthetic.}

\item{alpha.target}{A character string, one of \code{"all"},
\code{"segment"}, \code{"point"}, or \code{"none"}.}

\item{add.segments}{logical Display connecting segments or arrows between
original positions and displaced ones if both are available.}

\item{box.padding, point.padding}{numeric By how much each end of the segments
should shortened in mm.}

\item{segment.linewidth}{numeric Width of the segments or arrows in mm.}

\item{min.segment.length}{numeric Segments shorter that the minimum length
are not rendered, in mm.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A plot layer instance.
}
\description{
The geometry \code{"geom_point_s"} provides a super set of the capabilities of
geom \code{\link[ggplot2]{geom_point}} from package 'ggplot2' by allowing
plotting of arrows or segments joining the original position of displaced observations
to their current position rendered as points or graphic symbols. The most
common use is to demonstrate the action of different position functions. It
can be also used to highlight observations.
}
\details{
The plotting of segments is similar in idea to that implemented in
  \code{\link[ggrepel]{geom_text_repel}} and relies on position functions
  that rename instead of only replacing the original \code{x} and \code{y}
  coordinates from the \code{data} object.

  By default this geom uses \code{\link{position_nudge_center}} which is backwards
  compatible with \code{\link[ggplot2]{position_nudge}} but provides additional control
  on the direction of the nudging.
}
\note{
The insets are stored nested within the main ggplot object and
  contain their own copy of the data, and are rendered as grid grobs as normal
  ggplots at the time the main ggplot is rendered. They can have different
  themes.

  Use \code{\link{annotate}} as redefined in 'ggpp' when adding insets
  as annotations (automatically available unless 'ggpp' is not attached).
  \code{\link[ggplot2]{annotate}} cannot be used with the \code{npcx} and
  \code{npcy} pseudo-aesthetics.
}
\section{Position functions}{
 Many layer functions from package 'ggpp' are
  designed to work seamlessly with position functions that keep, rather than
  discard, the original \code{x} and \code{y} positions in \code{data} when
  computing a new displaced position. See \code{\link{position_nudge_keep}},
  \code{\link{position_dodge_keep}}, \code{\link{position_jitter_keep}},
  \code{\link{position_nudge_center}}, \code{\link{position_nudge_line}},
  \code{\link{position_nudge_to}}, \code{\link{position_dodgenudge}},
  \code{\link{position_jitternudge}}, and \code{\link{position_stacknudge}}
  for examples and details of their use.
}

\examples{

# Same output as with geom_point()
ggplot(mpg[1:20, ],
       aes(cyl, hwy)) +
  geom_point_s(colour = "blue")

# with segment drawn after nudging
ggplot(mpg[1:20, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_nudge_keep(x = 0.2),
               colour = "red") +
  geom_point_s(colour = "blue") +
  expand_limits(x = c(3.5, 8.5))

ggplot(mpg[1:20, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_nudge_keep(x = 0.2),
               colour = "blue",
               move.point = FALSE) +
  expand_limits(x = c(3.5, 8.5))

# with segment drawn after nudging
ggplot(mpg[1:20, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_nudge_keep(x = 0.2),
               colour = "red",
               colour.target = "all") +
  geom_point_s(colour = "blue")

ggplot(mpg[1:20, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_nudge_keep(x = 0.2),
               colour = "red",
               colour.target = "segment") +
  geom_point_s(colour = "blue")

ggplot(mpg[1:20, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_nudge_keep(x = 0.2),
               colour = "red",
               colour.target = "point") +
  geom_point_s(colour = "blue")

ggplot(mpg[1:50, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_jitternudge(width = 0.66, height = 2,
                                               seed = 456,
                                               nudge.from = "jittered",
                                               kept.origin = "original"),
               colour = "red",
               alpha = 0.3, alpha.target = "segment",
               arrow = grid::arrow(length = grid::unit(0.4, "lines"),
                                   ends = "first")) +
  geom_point_s(colour = "blue")

}
\seealso{
\code{\link[ggplot2]{geom_point}}.
}
