% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlases.R
\name{dk}
\alias{dk}
\title{Desikan-Killiany Cortical Atlas}
\usage{
dk()
}
\value{
A \code{ggseg_atlas} object with components:
\describe{
\item{atlas}{Character. Atlas name ("dk")}
\item{type}{Character. Atlas type ("cortical")}
\item{palette}{Named character vector of colours for each region}
\item{data}{A \code{ggseg_data_cortical} object containing:
\describe{
\item{vertices}{Data frame with \code{label} and \code{vertices} columns}
\item{sf}{Simple features data frame for 2D rendering}
}
}
}
}
\description{
Returns the Desikan-Killiany cortical parcellation atlas with 34 regions
per hemisphere (68 total) on the cortical surface.
}
\details{
This atlas is based on the FreeSurfer \code{aparc} annotation and is one of the
most widely used cortical parcellations in neuroimaging research.

The atlas works with both ggseg (2D polygon plots) and ggseg3d (3D mesh
visualizations) from a single object.
}
\section{Regions}{

The atlas contains 34 regions per hemisphere including:
banks of superior temporal sulcus, caudal anterior cingulate,
caudal middle frontal, cuneus, entorhinal, fusiform, inferior parietal,
inferior temporal, isthmus cingulate, lateral occipital,
lateral orbitofrontal, lingual, medial orbitofrontal, middle temporal,
parahippocampal, paracentral, pars opercularis, pars orbitalis,
pars triangularis, pericalcarine, postcentral, posterior cingulate,
precentral, precuneus, rostral anterior cingulate, rostral middle frontal,
superior frontal, superior parietal, superior temporal, supramarginal,
frontal pole, temporal pole, transverse temporal, and insula.
}

\examples{
dk()

atlas_regions(dk())
atlas_labels(dk())
}
\references{
Desikan RS, Segonne F, Fischl B, et al. (2006).
An automated labeling system for subdividing the human cerebral cortex
on MRI scans into gyral based regions of interest.
NeuroImage, 31(3):968-980.
\doi{10.1016/j.neuroimage.2006.01.021}

Fischl B, van der Kouwe A, Destrieux C, et al. (2004).
Automatically parcellating the human cerebral cortex.
Cerebral Cortex, 14(1):11-22.
\doi{10.1093/cercor/bhg087}
}
\seealso{
\code{\link[=aseg]{aseg()}} for subcortical structures,
\code{\link[=ggseg_atlas]{ggseg_atlas()}} for the atlas class constructor

Other ggseg_atlases: 
\code{\link{aseg}()},
\code{\link{tracula}()}
}
\concept{ggseg_atlases}
