% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg3d.R
\name{prepare_brain_meshes}
\alias{prepare_brain_meshes}
\alias{prepare_brain_meshes.cortical_atlas}
\alias{prepare_brain_meshes.subcortical_atlas}
\alias{prepare_brain_meshes.tract_atlas}
\title{Prepare brain meshes and legend data}
\usage{
prepare_brain_meshes(atlas, ...)

\method{prepare_brain_meshes}{cortical_atlas}(
  atlas,
  .data = NULL,
  surface = "LCBC",
  hemisphere = c("right", "left"),
  label_by = "region",
  text_by = NULL,
  colour_by = "colour",
  palette = NULL,
  na_colour = "darkgrey",
  na_alpha = 1,
  edge_by = NULL,
  brain_meshes = NULL,
  ...
)

\method{prepare_brain_meshes}{subcortical_atlas}(
  atlas,
  .data = NULL,
  label_by = "region",
  text_by = NULL,
  colour_by = "colour",
  palette = NULL,
  na_colour = "darkgrey",
  na_alpha = 1,
  ...
)

\method{prepare_brain_meshes}{tract_atlas}(
  atlas,
  .data = NULL,
  label_by = "region",
  text_by = NULL,
  colour_by = "colour",
  palette = NULL,
  na_colour = "darkgrey",
  na_alpha = 1,
  tract_color = c("palette", "orientation"),
  tube_radius = 2,
  tube_segments = 10,
  ...
)
}
\arguments{
\item{atlas}{A `ggseg_atlas` object}

\item{...}{Type-specific arguments passed to methods}

\item{.data}{Optional user data to merge}

\item{surface}{Surface type: `"inflated"` (default), `"semi-inflated"`,
`"white"`, `"pial"`. Use `"LCBC"` as alias for `"inflated"`.}

\item{hemisphere}{Character vector of hemispheres: `"right"`, `"left"`.}

\item{label_by}{Column name for region hover labels}

\item{text_by}{Column name for extra hover text}

\item{colour_by}{Column name for colour values}

\item{palette}{Colour palette specification}

\item{na_colour}{Colour for NA values}

\item{na_alpha}{Transparency for NA regions}

\item{edge_by}{Column name for region boundary edge grouping}

\item{brain_meshes}{Optional user-supplied brain meshes}

\item{tract_color}{`"palette"` (default) or `"orientation"`
(direction-based RGB colouring)}

\item{tube_radius}{Numeric tube radius (default 5 when `NULL`).}

\item{tube_segments}{Integer tube segment count (default 8 when `NULL`).}
}
\value{
List with `meshes` (list of mesh entries) and `legend_data`
}
\description{
S3 generic that dispatches to atlas-type-specific preparation methods.
Builds mesh data structures and legend data from a `ggseg_atlas`.
}
\keyword{internal}
