% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additions.R
\name{set_orthographic}
\alias{set_orthographic}
\title{Enable orthographic camera for ggseg3d plot}
\usage{
set_orthographic(p, ortho = TRUE, frustum_size = 220)
}
\arguments{
\item{p}{ggseg3d widget object}

\item{ortho}{logical. Enable orthographic mode (default: TRUE)}

\item{frustum_size}{numeric. Size of the orthographic frustum. Controls
how much of the scene is visible. Default 220 works well for brain meshes.
Use the same value across all views for consistent sizing.}
}
\value{
ggseg3d widget object with updated camera mode
}
\description{
Uses orthographic projection instead of perspective. This eliminates
perspective distortion and ensures consistent sizing across all views.
}
\examples{
\dontrun{
ggseg3d() |>
  set_orthographic()
}
}
