% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additions.R
\name{snapshot_brain}
\alias{snapshot_brain}
\title{Save ggseg3d widget as image}
\usage{
snapshot_brain(p, file, width = 600, height = 500, delay = 1, zoom = 2, ...)
}
\arguments{
\item{p}{ggseg3d widget object}

\item{file}{string. Output file path (should end in .png)}

\item{width}{numeric. Image width in pixels (default: 600)}

\item{height}{numeric. Image height in pixels (default: 500)}

\item{delay}{numeric. Seconds to wait for widget to render before capture
(default: 1)}

\item{zoom}{numeric. Zoom factor for higher resolution (default: 2)}

\item{...}{Additional arguments passed to webshot2::webshot}
}
\value{
The file path (invisibly)
}
\description{
Takes a screenshot of a ggseg3d widget and saves it as a PNG image.
Requires a Chrome-based browser to be installed.
}
\examples{
\dontrun{
ggseg3d() |>
  pan_camera("left lateral") |>
  snapshot_brain("brain.png")
}
}
