% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsom_plot.R
\name{geom_class}
\alias{geom_class}
\title{Visualization in parallelels coordinates in matrix of each attribute}
\usage{
geom_class(object_som, class = NULL, x_o = 3, y_o = 5.5, x_e = 3, y_e = 6.3)
}
\arguments{
\item{object_som}{object of Kohonen package}

\item{class}{categorical vector corresponding to the class of the dataset}

\item{x_o}{x-axis to map the number of observations of each neuron}

\item{y_o}{y-axis to map the number of observations of each neuron}

\item{x_e}{x-axis to map the entropy of each neuron}

\item{y_e}{y-axis to map the entropy of each neuron}
}
\value{
ggplot2 object
}
\description{
Visualization of the classes corresponding to each neuron of the SOM
}
\examples{
\donttest{
# Creating SOM object
iris_som <- kohonen::som(X = as.matrix(iris[1:4]),
                         grid =  kohonen::somgrid(xdim = 5,
                                                   ydim = 5,
                                                   neighbourhood.fct = "gaussian",
                                                   topo = "rectangular"),
                         rlen = 100)

# Creating ggsom class plot
geom_class(iris_som, class = iris$Species,
           x_o = 1, y_o = 6,
           x_e = 1.1, y_e = 7.4)
}
}
\references{
`ggplot2` package (https://CRAN.R-project.org/package=ggplot2)
}
\author{
Felipe Carvalho, \email{lipecaso@gmail.com}
}
