% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-fable.R
\name{autoplot.fbl_ts}
\alias{autoplot.fbl_ts}
\alias{autolayer.fbl_ts}
\title{Plot a set of forecasts}
\usage{
\method{autoplot}{fbl_ts}(object, data = NULL, level = c(80, 95), show_gap = TRUE, ...)

\method{autolayer}{fbl_ts}(
  object,
  data = NULL,
  level = c(80, 95),
  point_forecast = list(mean = mean),
  show_gap = TRUE,
  ...
)
}
\arguments{
\item{object}{A fable.}

\item{data}{A tsibble with the same key structure as the fable.}

\item{level}{The confidence level(s) for the plotted intervals.}

\item{show_gap}{Setting this to \code{FALSE} will connect the most recent value in \code{data} with the forecasts.}

\item{...}{Further arguments passed used to specify fixed aesthetics for the forecasts such as \code{colour = "red"} or \code{linewidth = 3}.}

\item{point_forecast}{The point forecast measure to be displayed in the plot.}
}
\description{
Produces a forecast plot from a fable. As the original data is not included
in the fable object, it will need to be specified via the \code{data} argument.
The \code{data} argument can be used to specify a shorter period of data, which is
useful to focus on the more recent observations.
}
\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE) && requireNamespace("tsibbledata", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(fable)
library(tsibbledata)

fc <- aus_production \%>\%
  model(ets = ETS(log(Beer) ~ error("M") + trend("Ad") + season("A"))) \%>\%
  forecast(h = "3 years")

fc \%>\%
  autoplot(aus_production)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) withAutoprint(\{ # examplesIf}
aus_production \%>\%
  autoplot(Beer) +
  autolayer(fc)
\dontshow{\}) # examplesIf}
}
