% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_rrp.R
\name{stat_rrp}
\alias{stat_rrp}
\title{Add R square and P-value to 'ggplot'}
\usage{
stat_rrp(
  x,
  y,
  model = "line2P",
  Pvalue.corrected = TRUE,
  show.Rsquare = TRUE,
  show.pvalue = TRUE,
  Rname = 0,
  Pname = 0,
  rrp.x = NULL,
  rrp.y = NULL,
  text.col = "black",
  eDigit = 3,
  eSize = 3
)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the 'ggplot'. Any reasonable way of defining the coordinates is acceptable.}

\item{model}{select which model to fit. Default is "line2P". The "model" should be one of c("line2P", "line3P", "log2P", "exp2P", "exp3P", "power2P", "power3P"), their formulas are as follows:\cr "line2P": y=a*x+b \cr "line3P": y=a*x^2+b*x+c \cr "log2P": y=a*ln(x)+b \cr "exp2P": y=a*exp(b*x) \cr "exp3P": y=a*exp(b*x)+c \cr "power2P": y=a*x^b \cr "power3P": y=a*x^b+c}

\item{Pvalue.corrected}{if P-value corrected or not, the value is one of c("TRUE", "FALSE").}

\item{show.Rsquare}{whether to show the R-square, the value is one of c("TRUE", "FALSE").}

\item{show.pvalue}{whether to show the P-value, the value is one of c("TRUE", "FALSE").}

\item{Rname}{to specify the character of R-square, the value is one of c(0, 1), corresponding to c(r^2, R^2).}

\item{Pname}{to specify the character of P-value, the value is one of c(0, 1), corresponding to c(p, P).}

\item{rrp.x, rrp.y}{the position for R square and P value.}

\item{text.col}{the color used for the equation text.}

\item{eDigit}{the numbers of digits for R square and P value. Default is 3.}

\item{eSize}{font size of R square and P value. Default is 3.}
}
\value{
No return value (called for side effects).
}
\description{
Add R-square and P-value of regression models to 'ggplot',
by using models built in the 'ggtrendline()' function. The function includes the following models: \cr
"line2P" (formula as: y=a*x+b), \cr  "line3P" (y=a*x^2+b*x+c), \cr "log2P" (y=a*ln(x)+b), \cr "exp2P" (y=a*exp(b*x)), \cr  "exp3P" (y=a*exp(b*x)+c), \cr "power2P" (y=a*x^b), \cr and "power3P" (y=a*x^b+c).
}
\details{
The values of each parameter of regression model can be found by typing \code{\link{trendline_sum}} function in this package.\cr\cr The linear models (line2P, line3P, log2P) in this package are estimated by \code{\link[stats]{lm}} function, while the nonlinear models (exp2P, exp3P, power2P, power3P) are estimated by \code{\link[stats]{nls}} function (i.e., least-squares method).\cr\cr The argument 'Pvalue.corrected' is only valid for non-linear regression.\cr\cr If "Pvalue.corrected = TRUE", the P-value is calculated by using "Residual Sum of Squares" and "Corrected Total Sum of Squares (i.e. sum((y-mean(y))^2))".\cr\cr If "Pvalue.corrected = FALSE", the P-value is calculated by using "Residual Sum of Squares" and "Uncorrected Total Sum of Squares (i.e. sum(y^2))".
}
\seealso{
\code{\link{ggtrendline}}, \code{\link{stat_eq}}, \code{\link{trendline_sum}}
}
