% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-series-circles.R
\docType{data}
\name{GeomSeriesText}
\alias{GeomSeriesText}
\alias{geom_series_text}
\title{Create series of circles labels text}
\format{
An object of class \code{GeomSeriesText} (inherits from \code{GeomText}, \code{Geom}, \code{ggproto}, \code{gg}) of length 1.
}
\usage{
GeomSeriesText

geom_series_text(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = NA,
  na.rm = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointly specified with
\code{nudge_x} or \code{nudge_y}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
A ggplot2 layer.
}
\description{
\code{geom_series_text} is designed to be used in concert with \link{geom_series_circles}.
It renders the \code{label} mapping to the final position of the series of circles sequence.

There are three arguments absolutely needed in \code{aes()} mappings:
\itemize{
\item \code{x} A vector mapping the abscissa  axis \code{x},  i.e. a character vector
when \code{x} is a numerical vector, or  a numerical vector when \code{y} is a character
vector.
\item \code{y} A vector mapping the ordinate axis \code{y}, i.e. a numerical vector
when \code{x} is a character vector or vice versa.
\item \code{label} Labels.
}
}
\examples{
my_df <- data.frame(cat = c("Apple", "Banana", "Pineapple"), val = c(2.65, 4.5, 6.25))
my_df |>
  ggplot2::ggplot() +
  geom_series_circles(ggplot2::aes(cat, val)) +
  geom_series_text(ggplot2::aes(cat, val, label = cat)) +
  ggplot2::coord_equal()
}
\keyword{datasets}
