% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.anosim.R
\name{autoplot.anosim}
\alias{autoplot.anosim}
\title{ggplot-based plot for objects of class \code{"anosim"}}
\usage{
\method{autoplot}{anosim}(
  object,
  notch = TRUE,
  varwidth = TRUE,
  xlab = NULL,
  ylab = NULL,
  title = "Analysis of similarities",
  subtitle = NULL,
  caption = bquote(R == .(r) * "," ~ P == .(p)),
  ...
)
}
\arguments{
\item{object}{an object of class \code{"anosim"}, the result of a call to
\code{\link[vegan:anosim]{vegan::anosim()}}.}

\item{notch}{logical; make notched (default) or standard box plot?}

\item{varwidth}{logical; make box width proportional to the square-root of
the number of observations in the group (default)?}

\item{xlab}{character; label for the x-axis.}

\item{ylab}{character; label for the y-axis.}

\item{title}{character; title for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{...}{additional arguments passed to other methods.}
}
\value{
A ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:anosim]{vegan::anosim()}}.
}
\examples{

library("vegan")

data(dune)
data(dune.env)
dune.dist <- vegdist(dune)
dune.ano <- with(dune.env, anosim(dune.dist, Management))

autoplot(dune.ano, notch = FALSE)
}
\author{
Didzis Elferts. Modifications by Gavin L. Simpson.
}
