% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.isomap.R
\name{autoplot.isomap}
\alias{autoplot.isomap}
\title{ggplot-based plot for objects of class \code{"isomap"}}
\usage{
\method{autoplot}{isomap}(
  object,
  axes = c(1, 2),
  geom = c("point", "text"),
  network = TRUE,
  line.col = "grey85",
  linewidth = 0.7,
  xlab = NULL,
  ylab = NULL,
  title = "Isometric feature mapping",
  subtitle = NULL,
  caption = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"isomap"}, the result of a call to
\code{\link[vegan:isomap]{vegan::isomap()}}.}

\item{axes}{numeric; which axes to plot, given as a vector of length 2.}

\item{geom}{character; which geom to use for the MDS scores layer.}

\item{network}{logical; should the edges of the ISOMAP network be drawn?}

\item{line.col}{colour with which to draw the network edges.}

\item{linewidth}{numeric; linewidth aesthetic for the log-series curve.}

\item{xlab}{character; label for the x-axis.}

\item{ylab}{character; label for the y-axis.}

\item{title}{character; subtitle for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{...}{additional arguments passed to other methods.}
}
\value{
A ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:isomap]{vegan::isomap()}}.
}
\examples{

library("vegan")

data(BCI)
dis <- vegdist(BCI)
ord <- isomap(dis, k = 3)

autoplot(ord)

autoplot(ord, geom = "text")
}
\author{
Gavin L. Simpson
}
