% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.prestonfit.R
\name{autoplot.prestonfit}
\alias{autoplot.prestonfit}
\title{Plot Preston's log-normal model of species abundance}
\usage{
\method{autoplot}{prestonfit}(
  object,
  show.fitted = TRUE,
  xlab = "Abundance",
  ylab = "Number of Species",
  title = "Preston's lognormal distribution",
  subtitle = NULL,
  caption = NULL,
  bar.col = NA,
  bar.fill = "grey35",
  line.col = "red",
  linewidth = 0.7,
  ...
)
}
\arguments{
\item{object}{an object of class \code{\link[vegan:fisherfit]{vegan::prestonfit()}}.}

\item{show.fitted}{logical; should the estimated distribution also be
plotted?}

\item{xlab}{character; label for the x axis.}

\item{ylab}{character; label for the y axis.}

\item{title}{character; title for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{bar.col}{colour for the bar outlines. The default, `NA``, does not
draw outlines around bars.}

\item{bar.fill}{fill colour for the bars.}

\item{line.col}{colour for Preston's log-normal curve.}

\item{linewidth}{numeric; size aesthetic for the log-normal curve.}

\item{...}{additional arguments passed to other methods.}
}
\value{
A ggplot object.
}
\description{
Draws a bar plot of species rank abundance with Preston's
log-normal model superimposed.
}
\examples{

library("vegan")

data(BCI)
pfit <- prestonfit(colSums(BCI))
autoplot(pfit)
}
\author{
Gavin L. Simpson
}
