% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.rda.R
\name{autoplot.rda}
\alias{autoplot.rda}
\title{ggplot-based plot for objects of class \code{'rda'}}
\usage{
\method{autoplot}{rda}(
  object,
  axes = c(1, 2),
  geom = c("point", "text"),
  layers = c("species", "sites", "biplot", "centroids"),
  arrows = TRUE,
  legend.position = "none",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ylab = NULL,
  xlab = NULL,
  const = NULL,
  arrow.col = "navy",
  ...
)
}
\arguments{
\item{object}{an object of class \code{"rda"}, the result of a call to
\code{\link[vegan:cca]{vegan::rda()}}}

\item{axes}{numeric; which axes to plot, given as a vector of length 2.}

\item{geom}{character; which geom to use for the species (variables) and
sites (samples) layers. A vector of length 2; if a vector of length 1,
\code{geom} is extended to the required length.}

\item{layers}{character; which scores to plot as layers}

\item{arrows}{logical; represent species (variables) using vectors?}

\item{legend.position}{character or two-element numeric vector; where to
position the legend. See \code{\link[ggplot2:theme]{ggplot2::theme()}} for details. Use \code{"none"}
to not draw the legend.}

\item{title}{character; subtitle for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{ylab}{character; label for the y-axis.}

\item{xlab}{character; label for the x-axis.}

\item{const}{General scaling constant to \code{rda} scores. See
\code{\link[vegan:plot.cca]{vegan::scores.rda()}} for details.}

\item{arrow.col}{colour specification for biplot arrows and their labels.}

\item{...}{Additional arguments passed to the \code{\link[=fortify]{fortify()}} method.}
}
\value{
Returns a ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:cca]{vegan::rda()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune)

pca <- rda(dune)
autoplot(pca)

## Just the species scores
autoplot(pca, layers = "species")
}
\author{
Gavin L. Simpson
}
