% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ggvolcano}
\alias{ggvolcano}
\title{Publication-ready volcano plots}
\usage{
ggvolcano(
  data,
  labels = "",
  logFC_col,
  pval_col,
  x_limits = c(min(data[[logFC_col]], na.rm = TRUE) - 1.5, max(data[[logFC_col]], na.rm =
    TRUE) + 1.5),
  y_limits = c(0, max(-log10(data[[pval_col]]), na.rm = TRUE) + 5),
  xlab = bquote(~Log[2] ~ "fold change"),
  ylab = bquote(~-Log[10] ~ italic(P)),
  title = "Volcano plot",
  subtitle = "",
  caption = paste0("total = ", nrow(data), " variables"),
  pval_cutoff = 1e-06,
  logFC_cutoff = 1,
  cutoff_line = list(type = "longdash", color = "black", width = 0.4),
  point_aes = list(size = 1.5, shape = c(19, 19, 19, 19), color = c("grey30", "#00CD6C",
    "#009ADE", "#FF1F5B"), alpha = 0.9),
  label_aes = list(size = 2.5, color = "black", face = "plain", parse = FALSE),
  legend_aes = list(labels = c("NS", expression(Log[2] ~ FC), "p-value", expression(p -
    value ~ and ~ log[2] ~ FC)), position = "right", label_size = 14, icon_size = 5),
  shade_options = NULL,
  connector_aes = list(line_width = 0.5, arrow_type = "closed", arrow_ends = "first",
    arrow_length = unit(0.01, "npc"), line_color = "grey10", direction = "both",
    draw_arrowheads = TRUE),
  gridlines = list(major = TRUE, minor = TRUE),
  plot_border = "partial",
  border_width = 0.8,
  border_color = "black",
  horizontal_line = NULL,
  horizontal_line_aes = list(type = "longdash", color = "black", width = 0.4)
)
}
\arguments{
\item{data}{A data frame containing test statistics. Requires at least columns for variable names, log2 fold changes, and p-values.}

\item{labels}{Column name or row names for variable names.}

\item{logFC_col}{Column name for log2 fold changes.}

\item{pval_col}{Column name for nominal or adjusted p-values.}

\item{x_limits}{Limits of the x-axis (default auto-calculated).}

\item{y_limits}{Limits of the y-axis (default auto-calculated).}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{title}{Plot title.}

\item{subtitle}{Plot subtitle.}

\item{caption}{Plot caption.}

\item{pval_cutoff}{P-value cutoff for significance.}

\item{logFC_cutoff}{Log2 fold-change cutoff for significance.}

\item{cutoff_line}{List of options for cutoff lines (`type`, `color`, `width`).}

\item{point_aes}{List of aesthetic options for points (`size`, `shape`, `color`, `alpha`).}

\item{label_aes}{List of aesthetic options for labels (`size`, `color`, `face`, `parse`).}

\item{legend_aes}{List of aesthetic options for legend (`labels`, `position`, `label_size`, `icon_size`).}

\item{shade_options}{List of options for shading regions in the plot.}

\item{connector_aes}{List of aesthetic options for connectors (`line_width`, `arrow_type`, `arrow_ends`, `arrow_length`, `line_color`, `direction`, `draw_arrowheads`).}

\item{gridlines}{List with logical values indicating whether to draw gridlines (`major`, `minor`).}

\item{plot_border}{Add a border for plot axes (`"partial"` or `"full"`).}

\item{border_width}{Width of the border.}

\item{border_color}{Color of the border.}

\item{horizontal_line}{Numeric value(s) for drawing horizontal line(s).}

\item{horizontal_line_aes}{List of aesthetic options for the horizontal line(s) (`type`, `color`, `width`).}
}
\value{
A \code{ggplot2} object representing the volcano plot.
}
\description{
Creates a volcano plot to visualize differential expression results.
This function is highly configurable to suit publication standards.
}
\examples{
data <- read.csv(system.file("extdata", "example.csv", package = "ggvolcano"))

ggvolcano(data,
  logFC_col = "log2FoldChange",
  pval_col = "pvalue",
  pval_cutoff = 10e-4,
  logFC_cutoff = 1.5,
  x_limits = c(-5.5, 5.5),
  y_limits = c(0, -log10(10e-12)),
  title = "Example Volcano plot",
  caption = "FC cutoff, 1.5; p-value cutoff, 10e-4",
  gridlines = list(major = TRUE, minor = TRUE),
  horizontal_line = 10e-8, # Draw horizontal line for p-value cutoff
  horizontal_line_aes = list(type = "dashed", color = "red", width = 0.5)
)

}
