% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gie_unav.R
\name{gie_unav}
\alias{gie_unav}
\title{gie_unav -- Download info on unavailabilities}
\usage{
gie_unav(
  country = NULL,
  start = NULL,
  end = NULL,
  type = NULL,
  end_flag = NULL,
  timeout = 3,
  size = 30,
  database = "agsi",
  apikey = Sys.getenv("GIE_APIKEY")
)
}
\arguments{
\item{country}{Character. Specify the country of interest as two-digit country code (e.g., 'DE', 'IE').}

\item{start}{Character. Specify the start of the time span you are \cr
interested in downloading (format: YYYY-MM-DD).}

\item{end}{Character. Specify the end of the time span you are \cr
interested in downloading (format: YYYY-MM-DD).}

\item{type}{Character. The type of unavailability info you want (choose between 'planned' and 'unplanned').}

\item{end_flag}{Character. The end flag for the unavailability info (choose between 'confirmed' and 'estimate').}

\item{timeout}{Numeric. If the amount of pages of your request exceeds 60, a timeout \cr
will be enforced to prevent the API from timing out. Defaults to 3 seconds, any \cr
values must be set in seconds, too.}

\item{size}{Integer. The number of results per page.}

\item{database}{Character. The type of API you want to address ('agsi' or 'alsi').}

\item{apikey}{Character. Your personal API key.}
}
\value{
A data.frame or list with the results.
}
\description{
Function to download data on AGSI+ and ALSI+ unavailability
}
\examples{
\dontrun{
gie_unav(country = "DE", date = "2022-01-03", database = "alsi")
}
}
