#' EHR data of patients affected by Glioblastoma (GBM), collected from Munich, Germany.
#'
#' The dataset contains data from 60 patients, treated at the 2 hospitals
#' Klinikum rechts der Isar (TUM) and Klinikum Bogenhausen (STKM),
#' Munich, Germany.\cr
#' It focuses on the prognostic impact of cytosolic Hsp70 (cHsp70) expression
#' and MGMT promoter methylation status.
#'
#' @docType data
#' @name munich2019dataset
#' @usage data(munich2019dataset)
#'
#' @format A data frame with 60 rows and 8 variables:
#' \describe{
#'  \item{age_years}{Numeric. Patient's age in years.}
#'  \item{cHsp70_low0_high1}{Factor. "Low" (0) or "High" (1) cytosolic Hsp70 expression.}
#'  \item{MGMTmethylation_methylated1_unmethylated0}{Factor "unmethylated" (0) or "methylated" (1) MGMT promoter.}
#'  \item{OS_months}{Numeric. Overall survival in months.}
#'  \item{PFS_months}{Numeric. Progression-free survival in months.}
#'  \item{sex_male0_female1}{Factor. "Male" (0) or "Female" (1).}
#'  \item{survived_yes1_no0}{Factor. "Dead" (0) or "Alive" (1) at their most recent check-up.}
#'  \item{tumor_progression_yes1_no0}{Factor. "No" (0) or "Yes" (1) for tumor progression after treatment.}
#' }
#'
#' @references
#' Lämmer F, Delbridge C. Würstle S et al. (2019)
#' Cytosolic Hsp70 as a biomarker to predict clinical outcome in patients with glioblastoma.
#' PMID: 31430337.
#' 14(8): e0221502.
#' https://doi.org/10.1371/journal.pone.0221502
#'
#' @keywords datasets
#'
#' @examples
#' data(munich2019dataset)
#' head(munich2019dataset)
"munich2019dataset"
